package org.jeecg.modules.statisticAnalysis.mapper;

import org.jeecg.modules.statisticAnalysis.vo.RailWearVO;

import java.util.List;
import java.util.Map;

/**
 * 统计分析
 */
public interface StatisticAnalysisMapper {

    /**
     * @param year
     * @return map
     * lightRailName = 线路名称
     * checkMonth = 检查月份
     * deductAveSum = 得分统计
     * checkNum = 当月检查次数
     */
    List<Map<String, Object>> getDynamicGeometry(String year);

    /**
     * @param startMonth
     * @param endMonth
     * @return map
     * lightRailName = 线路名称
     * damageType = 伤损种类（1-鱼鳞纹,2-剥落掉块,3-表面疲劳裂纹,4-轨底掉块,5-灼伤,6-核伤,7-焊缝,8-其他）
     * damageDegree = 伤损程度(1-轻伤,2-轻伤有发展,3-重伤)
     * checkNum = 检查次数
     */
    List<RailWearVO> getRailWear(String startMonth, String endMonth);
}
