package org.jeecg.modules.statisticAnalysis.service.impl;

import cn.hutool.core.convert.Convert;
import org.jeecg.modules.statisticAnalysis.mapper.StatisticAnalysisMapper;
import org.jeecg.modules.statisticAnalysis.service.StatisticAnalysisService;
import org.jeecg.modules.statisticAnalysis.vo.DynamicGeometryVO;
import org.jeecg.modules.statisticAnalysis.vo.RailWearVO;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 统计分析
 */
@Service
public class StatisticAnalysisServiceImpl implements StatisticAnalysisService {

    @Resource
    private StatisticAnalysisMapper statisticAnalysisMapper;

    @Override
    public List<DynamicGeometryVO> dynamicGeometry(String year) {
        List<DynamicGeometryVO> volist = new ArrayList<>();

        List<Map<String, Object>> records = statisticAnalysisMapper.getDynamicGeometry(year);
        Map<String, DynamicGeometryVO> recordMap = new HashMap<>();
        for (Map<String, Object> record : records) {
            // 线路
            String lightRailName = Convert.toStr(record.get("lightRailName"));
            // 检查月份
            Integer checkMonth = Convert.toInt(record.get("checkMonth"));
            // 检查得分
            BigDecimal deductAveSum = Convert.toBigDecimal(record.get("deductAveSum"));
            // 当月检查次数
            Integer checkNum = Convert.toInt(record.get("checkNum"));


            DynamicGeometryVO currentVo = recordMap.get(lightRailName);
            if (null == currentVo) {
                currentVo = new DynamicGeometryVO();

                // 检查线路名称
                currentVo.setLightRailName(lightRailName);

                // 检查数据其他对象以防其他的时候要用
                List<DynamicGeometryVO.CheckData> checkDataList = new ArrayList<>();
                currentVo.setCheckDataList(checkDataList);


                recordMap.put(lightRailName, currentVo);


                volist.add(currentVo);
            }

            // 存放数据对象
            List<DynamicGeometryVO.CheckData> checkDataList = currentVo.getCheckDataList();
            DynamicGeometryVO.CheckData checkData = new DynamicGeometryVO.CheckData();
            checkData.setCheckMonth(checkMonth);
            checkData.setDeductAveSum(deductAveSum);
            checkData.setCheckNum(checkNum);
            checkDataList.add(checkData);
        }

        return volist;
    }

    @Override
    public List<RailWearVO> railWear(String startMonth, String endMonth) {
        List<RailWearVO> records = statisticAnalysisMapper.getRailWear(startMonth, endMonth);
        for (RailWearVO record : records) {
            String label = getDamageTypeName(record.getDamageType()) + "-" + getDamageDegree(record.getDamageDegree());
            record.setLabel(label);
        }
        return records;
    }

    /**
     * 伤损程度(1-轻伤,2-轻伤有发展,3-重伤)
     */
    public static String getDamageDegree(Integer damageDegree) {
        String resultStr = "";
        switch (damageDegree) {
            case 1:
                resultStr = "轻伤";
                break;
            case 2:
                resultStr = "轻伤有发展";
                break;
            case 3:
                resultStr = "重伤";
                break;
            default:
                resultStr = "其他";
        }
        return resultStr;
    }

    /**
     * 伤损种类（1-鱼鳞纹,2-剥落掉块,3-表面疲劳裂纹,4-轨底掉块,5-灼伤,6-核伤,7-焊缝,8-其他）
     *
     * @param damageType
     * @return
     */
    public static String getDamageTypeName(Integer damageType) {
        String resultStr = "";
        switch (damageType) {
            case 1:
                resultStr = "鱼鳞纹";
                break;
            case 2:
                resultStr = "剥落掉块";
                break;
            case 3:
                resultStr = "表面疲劳裂纹";
                break;
            case 4:
                resultStr = "轨底掉块";
                break;
            case 5:
                resultStr = "灼伤";
                break;
            case 6:
                resultStr = "核伤";
                break;
            case 7:
                resultStr = "焊缝";
                break;
            default:
                resultStr = "其他";
        }
        return resultStr;
    }

}
