package org.jeecg.modules.statisticAnalysis.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;
import java.util.List;

@Data
@ApiModel(value = "RailWearVO对象", description = "统计分析-钢轨探伤记录")
public class RailWearVO {

    @ApiModelProperty("线路名称")
    private String lightRailName;

    @ApiModelProperty("伤损种类（1-鱼鳞纹,2-剥落掉块,3-表面疲劳裂纹,4-轨底掉块,5-灼伤,6-核伤,7-焊缝,8-其他）")
    private Integer damageType;

    @ApiModelProperty("伤损程度(1-轻伤,2-轻伤有发展,3-重伤)")
    private Integer damageDegree;

    @ApiModelProperty("检查次数")
    private Integer checkNum;

    @ApiModelProperty("标签")
    private String label;
}
