package org.jeecg.modules.subwayNetwork.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;

@Data
@ApiModel(value = "地铁站编辑DTO")
public class TrainStationEditDTO {

    @ApiModelProperty(value = "id")
    private String id;

    @ApiModelProperty(value = "轻轨线路ID")
    private String lightRailId;

    @ApiModelProperty(value = "车站名")
    private String stationName;

    @ApiModelProperty(value = "车站编码")
    private String stationCode;

    @ApiModelProperty(value = "线别id")
    private String lineAliasId;

    @ApiModelProperty(value = "起始里程")
    private BigDecimal startingMileage;

    @ApiModelProperty(value = "中心里程")
    private BigDecimal centerMileage;

    @ApiModelProperty(value = "结束里程")
    private BigDecimal endMileage;

    @ApiModelProperty(value = "序号")
    private Integer seq;

    @ApiModelProperty(value = "备注")
    private String remark;
}
