package org.jeecg.modules.subwayNetwork.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import org.jeecgframework.poi.excel.annotation.Excel;
import org.springframework.format.annotation.DateTimeFormat;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

/**
 * @Description: 线路车站-地铁站
 * @Author: jeecg-boot
 * @Date: 2023-06-14
 * @Version: V1.0
 */
@Data
@TableName("t_sn_train_station")
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "t_sn_train_station对象", description = "线路车站-地铁站")
public class TrainStation implements Serializable {
    private static final long serialVersionUID = 1L;

    /**
     * 主键
     */
    @TableId(type = IdType.ASSIGN_ID)
    @ApiModelProperty(value = "主键")
    private String id;
    /**
     * 创建人
     */
    @ApiModelProperty(value = "创建人")
    private String createBy;
    /**
     * 创建日期
     */
    @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @ApiModelProperty(value = "创建日期")
    private Date createTime;
    /**
     * 更新人
     */
    @ApiModelProperty(value = "更新人")
    private String updateBy;

    @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @ApiModelProperty(value = "更新日期")
    private Date updateTime;

    @ApiModelProperty(value = "轻轨线路ID")
    private String lightRailId;

    @ApiModelProperty(value = "车站名")
    private String stationName;

    @ApiModelProperty("所属线别id")
    private String lineAliasId;

    @ApiModelProperty(value = "起始里程")
    private BigDecimal startingMileage;

    @ApiModelProperty(value = "中心里程")
    private BigDecimal centerMileage;

    @ApiModelProperty(value = "结束里程")
    private BigDecimal endMileage;

    @ApiModelProperty(value = "序号")
    private Integer seq;

    @ApiModelProperty(value = "站长度(m)")
    private BigDecimal length;

    @ApiModelProperty(value = "备注")
    private String remark;
}
