package org.jeecg.modules.subwayNetwork.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;
import java.util.List;

@Data
@ApiModel(value = "SectionStationNode", description = "区间-站节点")
public class SectionStationNode {

    @ApiModelProperty(value = "id")
    private String id;

    @ApiModelProperty(value = "标签")
    private String label;

    @ApiModelProperty(value = "等级")
    private String level;

    @ApiModelProperty(value = "父节点")
    private String parent;

    @ApiModelProperty(value = "线别id")
    private String lineAliasId;

    @ApiModelProperty(value = "线别code【冠号】")
    private String lineAliasCode;

    @ApiModelProperty(value = "起始里程")
    private BigDecimal startMileage;

    @ApiModelProperty(value = "中心里程")
    private BigDecimal centerMileage;

    @ApiModelProperty(value = "结束里程")
    private BigDecimal endMileage;

    @ApiModelProperty(value = "是否是叶子节点")
    private Boolean isLeaf;

    @ApiModelProperty(value = "是否车站 1-是 0-否")
    private Integer isStation = 0;

    @ApiModelProperty(value = "孩子节点")
    private List<SectionStationNode> children;

}
