package org.jeecg.modules.unitDevice.vo;

import com.baomidou.mybatisplus.annotation.TableField;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;
import java.util.Date;

@Data
@ApiModel(value = "CaseReportWorkBatchVO对象", description = "单元设备-病例报告作业批次对象")
public class CaseReportWorkBatchVO {
    private static final long serialVersionUID = 1L;

    @ApiModelProperty("作业计划批次明细ID")
    private String workBatchDetailId;

    @ApiModelProperty("单元ID")
    private String unitId;

    @ApiModelProperty("作业计划批ID")
    private String workBatchId;

    @ApiModelProperty("作业计划批次号")
    private String workBatchCode;

    @ApiModelProperty("所属线路id")
    private String lightRailId;

    @ApiModelProperty("所属线路名称")
    private String lightRailName;

    @ApiModelProperty("所属线别id")
    private String lineAliasId;

    @ApiModelProperty("所属线别名称")
    private String lineAliasName;

    @ApiModelProperty("作业开始时间")
    private Date workStartTime;

    @ApiModelProperty("作业终止时间")
    private Date workEndTime;

    @ApiModelProperty("作业开始里程")
    private BigDecimal workStartMileage;

    @ApiModelProperty("做成结束里程")
    private BigDecimal workEndMileage;

    @ApiModelProperty("作业班组")
    private String team;

    @ApiModelProperty("来源 1-页面添加 2-超限派工添加")
    private Integer source;

    @ApiModelProperty("作业状态 0-未作业 9-已作业")
    private Integer workStatus;

    @ApiModelProperty("作业单元数量")
    private Integer workUnitDeviceNum;

    @ApiModelProperty("维修日期")
    private Date maintenanceDate;

    @ApiModelProperty("整改备注")
    private String reformRemark;

    @ApiModelProperty("备注")
    @TableField("remark")
    private String remark;

}
