package org.jeecg.modules.unitDevice.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;
import java.util.Date;

@Data
@ApiModel(value = "RailAddInstrumentCheckVO对象", description = "单元设备-病例报告本-添乘仪检查报告VO")
public class RailAddInstrumentCheckVO {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty("主键")
    private String id;

    @ApiModelProperty("动静态几何尺寸数据主表主键-》外键")
    private String checkId;

    @ApiModelProperty("动静态几何尺寸数据主表code")
    private String checkCode;

    @ApiModelProperty("设备单元id")
    private String unitId;

    @ApiModelProperty("设备单元编码")
    private String unitCode;

    @ApiModelProperty("设备单元编码")
    private String unitDeviceCode;

    @ApiModelProperty("设备单元类型1-钢轨,2-曲线,3-竖曲线,4-道岔")
    private Integer unitType;

    @ApiModelProperty("设备单元类型名称")
    private String unitTypeName;

    @ApiModelProperty("设备单元起始里程")
    private BigDecimal unitStartMileage;

    @ApiModelProperty("设备单元中心里程")
    private BigDecimal unitCenterMileage;

    @ApiModelProperty("设备单元终点里程")
    private BigDecimal unitEndMileage;

    @ApiModelProperty("测点里程")
    private BigDecimal pointMileage;

    @ApiModelProperty("水平加速度")
    private BigDecimal zontalSpeed;

    @ApiModelProperty("水平加速度等级")
    private Integer zontalSpeedLevel;

    @ApiModelProperty("垂直加速度")
    private BigDecimal verticalSpeed;

    @ApiModelProperty("垂直加速度等级")
    private Integer verticalSpeedLevel;

    @ApiModelProperty("速度")
    private BigDecimal speed;

    @ApiModelProperty("手动标记")
    private String mark;

    @ApiModelProperty("是否删除（0：未删除；1：已删除）")
    private String delFlag;

    @ApiModelProperty("排序字段")
    private Integer infoSort;
}
