package org.jeecg.modules.unitDevice.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;
import java.util.Date;

@Data
@ApiModel(value = "RailVehicleCheckVO对象", description = "单元设备-病例报告本-轨检车检查vo")
public class RailVehicleCheckVO {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty("主键")
    private String id;

    @ApiModelProperty("创建人")
    private String createBy;

    @ApiModelProperty("创建日期")
    private Date createTime;

    @ApiModelProperty("更新人")
    private String updateBy;

    @ApiModelProperty("更新时间")
    private Date updateTime;

    @ApiModelProperty("设备单元id")
    private String unitId;

    @ApiModelProperty("设备单元编码")
    private String unitCode;

    @ApiModelProperty("设备单元类型1-钢轨,2-曲线,3-竖曲线,4-道岔")
    private Integer unitType;

    @ApiModelProperty("设备单元类型名称")
    private String unitTypeName;

    @ApiModelProperty("设备单元起始里程")
    private BigDecimal unitStartingMileage;

    @ApiModelProperty("设备单元中心里程")
    private BigDecimal unitCenterMileage;

    @ApiModelProperty("设备单元终点里程")
    private BigDecimal unitEndMileage;

    @ApiModelProperty("检查数据类型 1-人工静态检查 2-轨检仪静态检查 3-轨检车检查 4-添乘仪检查")
    private Integer checkType;

    @ApiModelProperty("检查主表id")
    private String checkId;

    @ApiModelProperty("动静态几何尺寸数据主表code")
    private String checkCode;

    @ApiModelProperty("轨检车超限表id")
    private String overReportId;

    @ApiModelProperty("超限里程")
    private BigDecimal overReportMileage;

    @ApiModelProperty("超限类型")
    private String overType;

    @ApiModelProperty("超限等级")
    private Integer overLevel;

    @ApiModelProperty("长度(m)")
    private String longitude;

    @ApiModelProperty("峰值（mm或g）")
    private String peakValue;

    @ApiModelProperty("管理数据差")
    private String dataDifference;

    @ApiModelProperty("线性")
    private String xianxing;

    @ApiModelProperty("检测标准")
    private String standard;

    @ApiModelProperty("速度（km/h）")
    private String spend;

    @ApiModelProperty("备注")
    private String remark;

}
