package org.jeecg.modules.utils;

import java.util.HashMap;
import java.util.Map;

/**
 * @author 50519
 * 数据字典服务约定俗称的，
 * TODO: 后续迁移到redis
 */
public class DicMap {


    /**
     * 现场检查项目状态（1：合格；2：良好；3：不合格）
     */
    public final static String EK_APPROVAL_STATUS = "EK_APPROVAL_STATUS";

    /**
     * 巡道类型(1:步行巡道 2:乘车巡道)
     */
    public final static String PATROL_TYPE = "PATROL_TYPE";
    /**
     * 派工状态（0：未派工 1：已派工）
     */
    public final static String WORKER_STATUS = "WORKER_STATUS";

    /**
     * 作业状态（0：未作业 1：已作业）
     */
    public final static String SCHOOL_STATUS = "SCHOOL_STATUS";

    /**
     * 轨梁方向(1:正; 2：反)
     */
    public final static String DIRECTION = "DIRECTION";

    //*************************************映射MAP******************************************************************************
    /**
     * 作业状态（0：未作业 1：已作业）的map
     */
    public final static HashMap<Integer,String> DIRECTION_MAP = new HashMap<Integer,String>(){{
        put(1,"正");
        put(2,"反");
    }};
    /**
     * 作业状态（0：未作业 1：已作业）的map
     */
    public final static HashMap<Integer,String> SCHOOL_STATUS_MAP = new HashMap<Integer,String>(){{
        put(0,"未作业");
        put(1,"已作业");
    }};

    /**
     * 派工状态（0：未派工 1：已派工）的map
     */
    public final static HashMap<Integer,String> WORKER_STATUS_MAP = new HashMap<Integer,String>(){{
        put(0,"未派工");
        put(1,"已派工");
    }};

    /**
     * 现场检查项目状态对应的map
     */
    public final static HashMap<String,String> EK_APPROVAL_STATUS_MAP = new HashMap<String,String>(){{
        put("1","合格");
        put("2","良好");
        put("3","不合格");
    }};
    /**
     * 巡道类型对应的map
     */
    public final static HashMap<String,String> PATROL_TYPE_MAP = new HashMap<String,String>(){{
        put("1","步行巡道");
        put("2","乘车巡道");
    }};





    /**
     * 路由地址 此路由地址放在最后,最后加载
     *
     */
    public final static Map<String,HashMap<String,String>> ROUTE_MAP = new HashMap<String,HashMap<String,String>>(){{
        put("EK_APPROVAL_STATUS", EK_APPROVAL_STATUS_MAP);
        put("PATROL_TYPE", PATROL_TYPE_MAP);
    }};
    /**
     * 路由地址 此路由地址放在最后,最后加载数值类型
     *
     */
    public final static Map<String,HashMap<Integer,String>> ROUTE_INTEGER_MAP = new HashMap<String,HashMap<Integer,String>>(){{
        put("WORKER_STATUS", WORKER_STATUS_MAP);
        put("SCHOOL_STATUS", SCHOOL_STATUS_MAP);
        put("DIRECTION",DIRECTION_MAP);
    }};
}
