package org.jeecg.modules.base.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;

import java.util.Collection;
import java.util.List;
import org.apache.ibatis.annotations.Param;

/**
 * @Description : TODO
 * @Author : 黄康林
 * @Date : 2023-10-11 15:13:26
 * @Version : 1.0
 **/
public interface RootMapper<T> extends BaseMapper<T> {
    /**
     * 自定义批量插入
     * 如果要自动填充，@Param(xx) xx参数名必须是 list/collection/array 3个的其中之一
     */
    int insertBatch(@Param("list") List<T> list);

    /**
     * 自定义批量更新，条件为主键
     * 如果要自动填充，@Param(xx) xx参数名必须是 list/collection/array 3个的其中之一
     */
    int updateBatch(@Param("list") List<T> list);
}
