package org.jeecg.codegenerate;

import com.baomidou.mybatisplus.generator.FastAutoGenerator;
import com.baomidou.mybatisplus.generator.config.OutputFile;
import com.baomidou.mybatisplus.generator.config.po.TableInfo;
import com.baomidou.mybatisplus.generator.config.rules.DateType;
import com.baomidou.mybatisplus.generator.engine.FreemarkerTemplateEngine;
import org.jeecg.common.system.base.controller.JeecgController;
import org.jetbrains.annotations.NotNull;

import java.io.File;
import java.util.HashMap;
import java.util.Map;

public class CodeGenerate {
    public static String url = "jdbc:mysql://47.94.207.62:3306/hzgw_test?characterEncoding=UTF-8&useUnicode=true&useSSL=false&tinyInt1isBit=false&zeroDateTimeBehavior=convertToNull";
    public static String username = "root";
    public static String password = "superAdmin&321";

    public static void main(String[] args) {
        String projectPath = System.getProperty("user.dir");
        System.out.println("projectPath = " + projectPath);

        // 输出目录
        String outputDir = projectPath + "\\jeecg-module-system\\src\\main\\java\\";

        // 模块名
        String moduleName = "ekLine";

        // 表名
        String[] tables = {
                "t_mw_work_batch_detail_corrugation_info",
                "t_mw_work_batch_detail_curve_wear_info",
                "t_mw_work_batch_detail_patrol_assist_info",
                "t_mw_work_batch_detail_patrol_info",
                "t_mw_work_batch_detail_rail_wear_info",
                "t_mw_work_batch_detail_track_bed_info",
                "t_mw_work_batch_detail_turnout_info"
        };


        FastAutoGenerator.create(url, username, password)
                // 全局配置
                .globalConfig(builder -> {
                    builder.author("hkl")
                            .enableSwagger()
                            .commentDate("yyyy-MM-dd")
                            .dateType(DateType.ONLY_DATE)
                            .outputDir(outputDir)
                            .build();
                })
                // 包配置
                .packageConfig(builder -> {
                    builder.moduleName(moduleName)
                            .parent("org.jeecg.modules")
                            .service("service")
                            .serviceImpl("service.impl")
                            .mapper("mapper")
                            .xml("mapper.xml")
                            .controller("controller")
                            .build();
                })
                // 设置过滤前缀
                .strategyConfig(builder -> {
                    builder.addInclude(tables) // 设置需要生成的表名
                            .addTablePrefix("t_sn", "t_da", "t_ek", "t_xd", "t_dsg", "t_djt", "t_jh", "t_dsa", "t_mw"); // 设置过滤表前缀

                    // entity实体策略
                    builder.entityBuilder()
                            .enableLombok()
                            .enableTableFieldAnnotation();

                    // 控制层策略
                    builder.controllerBuilder()
                            .superClass(JeecgController.class)
                            .enableRestStyle();

                })
                .injectionConfig(consumer -> {
                    Map<String, String> customFile = new HashMap<>();
                    // DTO
                    customFile.put("DTO.java", "/generator/dto.java.ftl");
                    customFile.put("VO.java", "/generator/vo.java.ftl");
                    consumer.customFile(customFile).build();

                })

                // 使用Freemarker引擎模板，默认的是Velocity引擎模板
                .templateEngine(new EnhanceFreemarkerTemplateEngine())
                .execute();
    }

    /**
     * 代码生成器支持自定义[DTO\VO等]模版
     */
    public static class EnhanceFreemarkerTemplateEngine extends FreemarkerTemplateEngine {
        @Override
        protected void outputCustomFile(@NotNull Map<String, String> customFile, @NotNull TableInfo tableInfo, @NotNull Map<String, Object> objectMap) {
            String entityName = tableInfo.getEntityName();
            String otherPath = this.getPathInfo(OutputFile.other);
            customFile.forEach((key, value) -> {
                String fileName = String.format(otherPath + File.separator + entityName + "%s", key);
                this.outputFile(new File(fileName), objectMap, value);
            });
        }
    }
}
