package org.jeecg.modules.checkData.controller;


import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.jeecg.common.api.vo.Result;
import org.jeecg.common.aspect.annotation.AutoLog;
import org.jeecg.common.system.base.controller.JeecgController;
import org.jeecg.modules.checkData.dto.CurveWearRecordDTO;
import org.jeecg.modules.checkData.entity.CurveWearRecord;
import org.jeecg.modules.checkData.service.ICurveWearRecordService;
import org.jeecg.modules.checkData.vo.CurveWearRecordDetailVO;
import org.jeecg.modules.checkData.vo.CurveWearRecordVO;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * <p>
 * 检查数据设备-设备检查记录数据-曲线磨耗情况检查 前端控制器
 * </p>
 *
 * @author hkl
 * @since 2023-07-09
 */
@RestController
@RequestMapping("/checkData/equipmentCheckData/curveWearRecord")
@Api(tags = "检查数据设备-设备检查记录数据-曲线磨耗情况检查")
public class CurveWearRecordController extends JeecgController<CurveWearRecord, ICurveWearRecordService> {
    @AutoLog(value = "检查数据设备-设备检查记录数据-曲线磨耗情况检查-分页列表查询")
    @ApiOperation(value = "检查数据设备-设备检查记录数据-曲线磨耗情况检查-分页列表查询", notes = "检查数据设备-设备检查记录数据-曲线磨耗情况检查-分页列表查询")
    @GetMapping(value = "/list")
    public Result<IPage<CurveWearRecordVO>> queryPageList(@RequestParam(name = "pageNo", defaultValue = "1") Integer pageNo,
                                                          @RequestParam(name = "pageSize", defaultValue = "10") Integer pageSize,
                                                          CurveWearRecordDTO dto) {
        Page<CurveWearRecordVO> pageData = new Page<>(pageNo, pageSize);
        pageData = this.service.queryPageList(pageData, dto);
        return Result.OK(pageData);
    }

    @AutoLog(value = "检查数据设备-设备检查记录数据-曲线磨耗情况检查-获取曲线编号List")
    @ApiOperation(value = "检查数据设备-设备检查记录数据-曲线磨耗情况检查-获取道岔编号List", notes = "检查数据设备-设备检查记录数据-曲线磨耗情况检查-获取道岔编号List")
    @GetMapping(value = "/getCurveCodeList")
    public Result<Map<String, List<CurveWearRecord>>> getCurveCodeList(@ApiParam("设备检查记录主表id") String recordsMasterCheckId) {
        List<CurveWearRecord> records = this.service.lambdaQuery()
                .eq(CurveWearRecord::getRecordsMasterCheckId, recordsMasterCheckId)
                .list();
        Map<String, List<CurveWearRecord>> map = records.stream().collect(Collectors.groupingBy(CurveWearRecord::getCurveCode));

        return Result.OK(map);
    }


//    @AutoLog(value = "检查数据设备-设备检查记录数据-曲线磨耗情况检查-曲线检查详情页")
//    @ApiOperation(value = "检查数据设备-设备检查记录数据-曲线磨耗情况检查-曲线检查详情页", notes = "检查数据设备-设备检查记录数据-曲线磨耗情况检查-道岔检查详情页")
//    @GetMapping(value = "/getDetail")
//    public Result<List<CurveWearRecordDetailVO>> getDetail(@ApiParam("检查主表id") String masterRecordId) {
//        List<CurveWearRecordDetailVO> dataList = this.service.getDetail(masterRecordId);
//        return Result.OK(dataList);
//    }
}
