package org.jeecg.modules.checkData.controller;


import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.jeecg.common.api.vo.Result;
import org.jeecg.common.aspect.annotation.AutoLog;
import org.jeecg.common.system.base.controller.JeecgController;
import org.jeecg.modules.checkData.dto.RailWearRecordDTO;
import org.jeecg.modules.checkData.entity.RailWearRecord;
import org.jeecg.modules.checkData.service.IRailWearRecordService;
import org.jeecg.modules.checkData.vo.RailWearRecordDetailVO;
import org.jeecg.modules.checkData.vo.RailWearRecordVO;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/**
 * <p>
 * 检查数据-设备检查记录数据-钢轨伤损情况检查表 前端控制器
 * </p>
 *
 * @author hkl
 * @since 2023-07-09
 */
@RestController
@RequestMapping("/checkData/equipmentCheckData/railWearRecord")
@Api(tags = "检查数据-设备检查记录数据-钢轨伤损情况检查表")
public class RailWearRecordController extends JeecgController<RailWearRecord, IRailWearRecordService> {

    @AutoLog(value = "检查数据-设备检查记录数据-钢轨伤损情况检查表-分页列表查询")
    @ApiOperation(value = "检查数据-设备检查记录数据-钢轨伤损情况检查表-分页列表查询", notes = "检查数据-设备检查记录数据-钢轨伤损情况检查表-分页列表查询")
    @GetMapping(value = "/list")
    public Result<IPage<RailWearRecordVO>> queryPageList(@RequestParam(name = "pageNo", defaultValue = "1") Integer pageNo,
                                                         @RequestParam(name = "pageSize", defaultValue = "10") Integer pageSize,
                                                         RailWearRecordDTO dto) {
        Page<RailWearRecordVO> pageData = new Page<>(pageNo, pageSize);
        pageData = this.service.queryPageList(pageData, dto);
        return Result.OK(pageData);
    }


    @AutoLog(value = "检查数据-设备检查记录数据-钢轨伤损情况检查详情页面")
    @ApiOperation(value = "检查数据-设备检查记录数据-钢轨伤损情况检查详情页面", notes = "检查数据-设备检查记录数据-钢轨伤损情况检查详情页面")
    @GetMapping(value = "/getDetail")
    public Result<List<RailWearRecordDetailVO>> getDetail(@ApiParam("id") String id) {
        List<RailWearRecordDetailVO> data = this.service.getDetail(id);
        return Result.OK(data);
    }

}
