package org.jeecg.modules.checkData.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;

/**
 * <p>
 * 检查数据设备-设备检查记录数据-曲线磨耗情况检查
 * </p>
 *
 * @author hkl
 * @since 2023-07-09
 */
@Data
@ApiModel(value = "CurveWearRecordDTO对象", description = "检查数据设备-设备检查记录数据-曲线磨耗情况检查")
public class CurveWearRecordDTO {
    private static final long serialVersionUID = 1L;

    @ApiModelProperty("曲线编码")
    private String curveCode;

    @ApiModelProperty("检查编号")
    private String ekCode;

    @ApiModelProperty("开始时间")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private Date startTime;

    @ApiModelProperty("结束时间")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private Date endTime;
}
