package org.jeecg.modules.checkData.dto;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;

/**
 * <p>
 * 轨检车-》轨道动态几何尺寸容许值差管理值
 * </p>
 *
 * @author hkl
 * @since 2023-07-27
 */
@Data
public class MovementDiferenceManagerDTO {


    private static final long serialVersionUID = 1L;

    @ApiModelProperty("主键")
    private String id;

    @ApiModelProperty("创建人")
    private String createBy;

    @ApiModelProperty("创建日期")
    @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date createTime;

    @ApiModelProperty("更新人")
    private String updateBy;

    @ApiModelProperty("更新时间")
    @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date updateTime;

    @ApiModelProperty("动静态几何尺寸数据主表主键-》外键")
    private String movementMasterId;

    @ApiModelProperty("最小速度等级")
    private String minSpendLevel;

    @ApiModelProperty("最大速度等级")
    private String maxSpendLevel;

    @ApiModelProperty("超限等级")
    private String exceedLevel;

    @ApiModelProperty("高低（mm）")
    private String height;

    @ApiModelProperty("轨向（mm）")
    private String trackAlignment;

    @ApiModelProperty("大轨距（mm）")
    private String maxTrackGauge;

    @ApiModelProperty("小轨距（mm）")
    private String minTrackGauge;

    @ApiModelProperty("水平（mm）")
    private String level;

    @ApiModelProperty("三角坑（mm）")
    private String triangularPit;

    @ApiModelProperty("垂直加速度（g）")
    private String verticalSpend;

    @ApiModelProperty("横向加速度（g）")
    private String transverseSpend;

    @ApiModelProperty("轨距变化率")
    private String gaugeChange;

    @ApiModelProperty("曲率变化率")
    private String curvatureChange;

    @ApiModelProperty("扣分标准")
    private String deductStandard;

    @ApiModelProperty("是否删除（0：未删除； 1：已删除）")
    private String delFlag;

    @ApiModelProperty("导入顺序")
    private Integer sort;


}
