package org.jeecg.modules.checkData.dto;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.math.BigDecimal;
import java.util.Date;

/**
 * <p>
 * 设备检查记录主表接收类
 * </p>
 *
 * @author hkl
 * @since 2023-07-07
 */
@Data
public class RecordsMasterCheckDTO {


    private static final long serialVersionUID = 1L;

    @ApiModelProperty("主键")
    private String id;

    @ApiModelProperty("创建人")
    private String createBy;

    @ApiModelProperty("创建日期")
    @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date createTime;

    @ApiModelProperty("更新人")
    private String updateBy;

    @ApiModelProperty("更新时间")
    @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date updateTime;

    @ApiModelProperty("设备检查类型（1：道岔使用情况；2：钢轨伤损情况；3：曲线磨损情况；4：钢轨波磨情况；5：道床使用情况）")
    private String type;

    @ApiModelProperty("检查批次编号")
    private String ekCode;

    @ApiModelProperty("工单编号")
    private String workCode;

    @ApiModelProperty("轨距水平尺编号")
    private String gaugeCode;

    @ApiModelProperty("检查区间id")
    private String subwaySectionId;

    @ApiModelProperty("检查区间名称")
    private String subwaySectionName;

    @ApiModelProperty("所属线路id")
    private String lightRailId;

    @ApiModelProperty("所属线路名称")
    private String lightRailName;

    @ApiModelProperty("所属线别id")
    private String lineAliasId;

    @ApiModelProperty("所属线别名称")
    private String lineAliasName;

    @ApiModelProperty("起始里程")
    private BigDecimal startingMileage;

    @ApiModelProperty("终点里程")
    private BigDecimal endMileage;

    @ApiModelProperty("共通字段1(根据字段type来赋值)->(线路方向)")
    private String numOne;

    @ApiModelProperty("共通字段2(根据字段type来赋值)->（推行方向）")
    private String numTwo;

    @ApiModelProperty("共通字段3(根据字段type来赋值)->(检查时间)")
    private String numThree;

    @ApiModelProperty("备注")
    private String remark;

    @ApiModelProperty("检查人姓名")
    private String checkBy;

    @ApiModelProperty("检查日期")
    @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private Date checkTime;

    @ApiModelProperty("审核人姓名")
    private String verifyBy;

    @ApiModelProperty("审核时间")
    @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private Date verifyTime;

    @ApiModelProperty("是否删除（0：未删除；1：已删除）")
    private String delFlag;

    @ApiModelProperty("开始时间")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private Date startTime;

    @ApiModelProperty("结束时间")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private Date endTime;


}
