package org.jeecg.modules.checkData.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonIgnore;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import org.springframework.format.annotation.DateTimeFormat;

/**
 * <p>
 * 动静态几何尺寸对应得里程相关信息详情表
 * </p>
 *
 * @author hkl
 * @since 2023-07-11
 */
@Getter
@Setter
@TableName("t_djt_movement_course_info")
@ApiModel(value = "MovementCourseInfo对象", description = "动静态几何尺寸对应得里程相关信息详情表")
public class MovementCourseInfo implements Serializable {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty("主键")
    @TableId("id")
    private String id;

    @ApiModelProperty("创建人")
    @TableField("create_by")
    private String createBy;

    @ApiModelProperty("创建日期")
    @TableField("create_time")
    @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private Date createTime;

    @ApiModelProperty("更新人")
    @TableField("update_by")
    private String updateBy;

    @ApiModelProperty("更新时间")
    @TableField("update_time")
    @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private Date updateTime;

    @ApiModelProperty("动静态几何尺寸数据主表主键-》外键")
    @TableField("movement_master_id")
    private String movementMasterId;

    @ApiModelProperty("动静态几何尺寸对应得里程信息主键-》外键")
    @TableField("movement_course_id")
    private String movementCourseId;

    @ApiModelProperty("轨号")
    @TableField("track_code")
    private String trackCode;

    @ApiModelProperty("测点")
    @TableField("measure_point")
    private Integer measurePoint;

    @ApiModelProperty("轨距")
    @TableField("track_gauge")
    private String trackGauge;

    @ApiModelProperty("水平")
    @TableField("level")
    private String level;

    @ApiModelProperty("三角坑")
    @TableField("triangular_pit")
    private String triangularPit;

    @ApiModelProperty("方向")
    @TableField("direction")
    private String direction;

    @ApiModelProperty("高低")
    @TableField("height")
    private String height;

    @ApiModelProperty("结构")
    @TableField("structure")
    private String structure;

    @ApiModelProperty("整改")
    @TableField("rectification")
    private String rectification;

    @ApiModelProperty("是否删除（0：未删除；1：已删除）")
    @TableField("del_flag")
    private String delFlag;

    @ApiModelProperty("导入顺序")
    @TableField("info_sort")
    private Integer infoSort;

    @ApiModelProperty("当前格子的起始里程:计算用")
    @TableField(exist = false)
    @JsonIgnore
    private BigDecimal currentStartMileage;

    @ApiModelProperty("当前格子的起始里程:计算用")
    @TableField(exist = false)
    @JsonIgnore
    private BigDecimal currentEndEndMileage;


}
