package org.jeecg.modules.checkData.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import org.springframework.format.annotation.DateTimeFormat;

/**
 * <p>
 * 动静态几何尺寸数据主表	
 * </p>
 *
 * @author hkl
 * @since 2023-07-11
 */
@Getter
@Setter
@TableName("t_djt_movement_records_master")
@ApiModel(value = "MovementRecordsMaster对象", description = "动静态几何尺寸数据主表	")
public class MovementRecordsMaster implements Serializable {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty("主键")
    @TableId("id")
    private String id;

    @ApiModelProperty("创建人")
    @TableField("create_by")
    private String createBy;

    @ApiModelProperty("创建日期")
    @TableField("create_time")
    @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date createTime;

    @ApiModelProperty("更新人")
    @TableField("update_by")
    private String updateBy;

    @ApiModelProperty("更新时间")
    @TableField("update_time")
    @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date updateTime;

    @ApiModelProperty("动态几何尺寸类型（1：人工静态检查；2：轨检仪静态检查; 3:轨检车检查；4：添乘仪检查）")
    @TableField("type")
    private String type;

    @ApiModelProperty("检查批次编号")
    @TableField("ek_code")
    private String ekCode;

    @ApiModelProperty("轨检车号")
    @TableField("track_code")
    private String trackCode;

    @ApiModelProperty("工单编号")
    @TableField("work_code")
    private String workCode;

    @ApiModelProperty("检查区间id")
    @TableField("subway_section_id")
    private String subwaySectionId;

    @ApiModelProperty("检查区间名称")
    @TableField("subway_section_name")
    private String subwaySectionName;

    @ApiModelProperty("所属线路id")
    @TableField("light_rail_id")
    private String lightRailId;

    @ApiModelProperty("所属线路名称")
    @TableField("light_rail_name")
    private String lightRailName;

    @ApiModelProperty("所属线别id")
    @TableField("line_alias_id")
    private String lineAliasId;

    @ApiModelProperty("所属线别名称")
    @TableField("line_alias_name")
    private String lineAliasName;

    @ApiModelProperty("起始里程")
    @TableField("starting_mileage")
    private BigDecimal startingMileage;

    @ApiModelProperty("终点里程")
    @TableField("end_mileage")
    private BigDecimal endMileage;

    @ApiModelProperty("开始速度等级")
    @TableField("start_level")
    private String startLevel;

    @ApiModelProperty("结束速度等级")
    @TableField("end_level")
    private String endLevel;

    @ApiModelProperty("轨梁方向(1:正；2：反)")
    @TableField("direction")
    private Integer direction;

    @ApiModelProperty("钢轨单元数量")
    @TableField("rail_num")
    private Integer railNum;

    @ApiModelProperty("曲线数量")
    @TableField("curve_num")
    private Integer curveNum;

    @ApiModelProperty("竖曲线数量")
    @TableField("vertical_curve_num")
    private Integer verticalCurveNum;

    @ApiModelProperty("道岔数量")
    @TableField("switch_num")
    private Integer switchNum;

    @ApiModelProperty("检查人姓名")
    @TableField("check_by")
    private String checkBy;

    @ApiModelProperty("检查日期")
    @TableField("check_time")
    @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private Date checkTime;

    @ApiModelProperty("审核人姓名")
    @TableField("verify_by")
    private String verifyBy;

    @ApiModelProperty("审核时间")
    @TableField("verify_time")
    @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private Date verifyTime;

    @ApiModelProperty("打印日期")
    @TableField("print_time")
    @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private Date printTime;

    @ApiModelProperty("备注")
    @TableField("remark")
    private String remark;

    @ApiModelProperty("是否删除（0：未删除；1：已删除）")
    @TableField("del_flag")
    private String delFlag;


}
