package org.jeecg.modules.checkData.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import org.springframework.format.annotation.DateTimeFormat;

/**
 * <p>
 * 轨检车-》区段总结报告	
 * </p>
 *
 * @author hkl
 * @since 2023-07-27
 */
@Getter
@Setter
@TableName("t_djt_movement_section_report")
@ApiModel(value = "MovementSectionReport对象", description = "轨检车-》区段总结报告	")
public class MovementSectionReport implements Serializable {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty("主键")
    @TableId("id")
    private String id;

    @ApiModelProperty("创建人")
    @TableField("create_by")
    private String createBy;

    @ApiModelProperty("创建日期")
    @TableField("create_time")
    @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date createTime;

    @ApiModelProperty("更新人")
    @TableField("update_by")
    private String updateBy;

    @ApiModelProperty("更新时间")
    @TableField("update_time")
    @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date updateTime;

    @ApiModelProperty("动静态几何尺寸数据主表主键-》外键")
    @TableField("movement_master_id")
    private String movementMasterId;

    @ApiModelProperty("项目名称")
    @TableField("project_name")
    private String projectName;

    @ApiModelProperty("个数->一级")
    @TableField("number_one")
    private String numberOne;

    @ApiModelProperty("个数->二级")
    @TableField("number_two")
    private String numberTwo;

    @ApiModelProperty("个数->三级")
    @TableField("number_three")
    private String numberThree;

    @ApiModelProperty("个数->四级")
    @TableField("number_four")
    private String numberFour;

    @ApiModelProperty("个数->总数")
    @TableField("number_sum")
    private String numberSum;

    @ApiModelProperty("个数->个数/公里")
    @TableField("number_ave")
    private String numberAve;

    @ApiModelProperty("个数->百分比")
    @TableField("number_per")
    private String numberPer;

    @ApiModelProperty("扣分->扣分总计")
    @TableField("deduct_sum")
    private String deductSum;

    @ApiModelProperty("扣分->扣分/公里")
    @TableField("deduct_ave")
    private String deductAve;

    @ApiModelProperty("扣分->扣分百分比")
    @TableField("deduct_per")
    private String deductPer;

    @ApiModelProperty("TQI->平均指数")
    @TableField("tqi_ave")
    private String tqiAve;

    @ApiModelProperty("TQI->超标段数")
    @TableField("tqi_exceed_num")
    private String tqiExceedNum;

    @ApiModelProperty("TQI->超标百分比")
    @TableField("tqi_exceed_per")
    private String tqiExceedPer;

    @ApiModelProperty("是否删除（0：未删除； 1：已删除）")
    @TableField("del_flag")
    private String delFlag;

    @ApiModelProperty("导入顺序")
    @TableField("sort")
    private Integer sort;


}
