package org.jeecg.modules.checkData.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import java.io.Serializable;
import java.util.Date;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import org.springframework.format.annotation.DateTimeFormat;

/**
 * <p>
 * 轨检车-》200m区段轨道不平顺质量指数TQI管理标准(单位：mm)	
 * </p>
 *
 * @author hkl
 * @since 2023-07-27
 */
@Getter
@Setter
@TableName("t_djt_movement_tqi_standard_manager")
@ApiModel(value = "MovementTqiStandardManager对象", description = "轨检车-》200m区段轨道不平顺质量指数TQI管理标准(单位：mm)	")
public class MovementTqiStandardManager implements Serializable {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty("主键")
    @TableId("id")
    private String id;

    @ApiModelProperty("创建人")
    @TableField("create_by")
    private String createBy;

    @ApiModelProperty("创建日期")
    @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @TableField("create_time")
    private Date createTime;

    @ApiModelProperty("更新人")
    @TableField("update_by")
    private String updateBy;

    @ApiModelProperty("更新时间")
    @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @TableField("update_time")
    private Date updateTime;

    @ApiModelProperty("动静态几何尺寸数据主表主键-》外键")
    @TableField("movement_master_id")
    private String movementMasterId;

    @ApiModelProperty("最小速度等级")
    @TableField("min_spend_level")
    private String minSpendLevel;

    @ApiModelProperty("最大速度等级")
    @TableField("max_spend_level")
    private String maxSpendLevel;

    @ApiModelProperty("高低（mm）")
    @TableField("height")
    private String height;

    @ApiModelProperty("轨向（mm）")
    @TableField("track_alignment")
    private String trackAlignment;

    @ApiModelProperty("轨距（mm）")
    @TableField("track_gauge")
    private String trackGauge;

    @ApiModelProperty("水平（mm）")
    @TableField("level")
    private String level;

    @ApiModelProperty("三角坑（mm）")
    @TableField("triangular_pit")
    private String triangularPit;

    @ApiModelProperty("TQI")
    @TableField("tqi_value")
    private String tqiValue;

    @ApiModelProperty("超标<=10%->TQI最小值")
    @TableField("min_tqi_exceed_ten")
    private String minTqiExceedTen;

    @ApiModelProperty("超标<=10%->TQI最大值")
    @TableField("max_tqi_exceed_ten")
    private String maxTqiExceedTen;

    @ApiModelProperty("超标<=10%->扣分")
    @TableField("tqi_exceed_ten_deduct")
    private String tqiExceedTenDeduct;

    @ApiModelProperty("超标<=20%->TQI最小值")
    @TableField("min_tqi_exceed_twenty")
    private String minTqiExceedTwenty;

    @ApiModelProperty("超标<=20%->TQI最大值")
    @TableField("max_tqi_exceed_twenty")
    private String maxTqiExceedTwenty;

    @ApiModelProperty("超标<=20%->扣分")
    @TableField("tqi_exceed_twenty_deduct")
    private String tqiExceedTwentyDeduct;

    @ApiModelProperty("超标>20%->TQI最小值")
    @TableField("min_tqi_exceed_pass_twenty")
    private String minTqiExceedPassTwenty;

    @ApiModelProperty("超标>20%->TQI扣分")
    @TableField("tqi_exceed_pass_twenty_deduct")
    private String tqiExceedPassTwentyDeduct;

    @ApiModelProperty("是否删除（0：未删除； 1：已删除）")
    @TableField("del_flag")
    private String delFlag;

    @ApiModelProperty("导入顺序")
    @TableField("sort")
    private Integer sort;


}
