package org.jeecg.modules.checkData.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

/**
 * <p>
 * 检查数据-动静态几何尺寸数据-轨检仪静态检查数据-检查项目
 * </p>
 *
 * @author hkl
 * @since 2023-07-16
 */
@Getter
@Setter
@TableName("t_dsg_rail_inspection_equipment_item")
@ApiModel(value = "RailInspectionEquipmentItem对象", description = "检查数据-动静态几何尺寸数据-轨检仪静态检查数据-检查项目")
public class RailInspectionEquipmentItem implements Serializable {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty("主键")
    @TableId("id")
    private String id;

    @ApiModelProperty("创建人")
    @TableField("create_by")
    private String createBy;

    @ApiModelProperty("创建日期")
    @TableField("create_time")
    private Date createTime;

    @ApiModelProperty("更新人")
    @TableField("update_by")
    private String updateBy;

    @ApiModelProperty("更新时间")
    @TableField("update_time")
    private Date updateTime;

    @ApiModelProperty("轨检仪静态检查数据id")
    @TableField("rail_inspection_equipment_id")
    private String railInspectionEquipmentId;

    @ApiModelProperty("检查起始里程（km）")
    @TableField("course_starting_mileage")
    private BigDecimal courseStartingMileage;

    @ApiModelProperty("检查终点里程(km)")
    @TableField("course_end_mileage")
    private BigDecimal courseEndMileage;

    @ApiModelProperty("曲线半径（m）")
    @TableField("curve_radius")
    private BigDecimal curveRadius;

    @ApiModelProperty("超高（mm）")
    @TableField("super_high")
    private BigDecimal superHigh;

    @ApiModelProperty("加宽（mm）")
    @TableField("widen")
    private BigDecimal widen;

    @ApiModelProperty("顺坡率（‰）")
    @TableField("slope_ratio")
    private BigDecimal slopeRatio;

    @ApiModelProperty("长度（m）")
    @TableField("long_extent")
    private BigDecimal longExtent;

    @ApiModelProperty("备注")
    @TableField("remark")
    private String remark;

    @ApiModelProperty("是否删除（0：未删除；1：已删除）")
    @TableField("del_flag")
    private String delFlag;

    @ApiModelProperty("导入排序")
    @TableField("sort")
    private Integer sort;


}
