package org.jeecg.modules.checkData.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import java.io.Serializable;
import java.util.Date;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import org.springframework.format.annotation.DateTimeFormat;

/**
 * <p>
 * 检查数据设备-设备检查记录数据-道岔使用情况检查数据
 * </p>
 *
 * @author hkl
 * @since 2023-08-01
 */
@Getter
@Setter
@TableName("t_ek_records_master_turnout_info")
@ApiModel(value = "RecordsMasterTurnoutInfo对象", description = "检查数据设备-设备检查记录数据-道岔使用情况检查数据")
public class RecordsMasterTurnoutInfo implements Serializable {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty("主键")
    @TableId("id")
    private String id;

    @ApiModelProperty("创建人")
    @TableField("create_by")
    private String createBy;

    @ApiModelProperty("创建日期")
    @TableField("create_time")
    @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date createTime;

    @ApiModelProperty("更新人")
    @TableField("update_by")
    private String updateBy;

    @ApiModelProperty("更新时间")
    @TableField("update_time")
    @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date updateTime;

    @ApiModelProperty("设备检查记录主表id")
    @TableField("records_master_id")
    private String recordsMasterId;

    @ApiModelProperty("道岔编号")
    @TableField("switch_code")
    private String switchCode;

    @ApiModelProperty("道岔号数")
    @TableField("switch_code_num")
    private String switchCodeNum;

    @ApiModelProperty("检查项目类型（1：轨距；2：水平；3：支距；4：轮缘槽；5：滑床板；6：顶铁；7：接头螺栓；8：护轨螺栓；9:道岔）")
    @TableField("type")
    private String type;


    @ApiModelProperty("值1")
    @TableField("num_one")
    private String numOne;

    @ApiModelProperty("值2")
    @TableField("num_two")
    private String numTwo;

    @ApiModelProperty("值3")
    @TableField("num_three")
    private String numThree;

    @ApiModelProperty("值4")
    @TableField("num_four")
    private String numFour;

    @ApiModelProperty("值5")
    @TableField("num_five")
    private String numFive;

    @ApiModelProperty("值6")
    @TableField("num_six")
    private String numSix;

    @ApiModelProperty("值7")
    @TableField("num_seven")
    private String numSeven;

    @ApiModelProperty("值8")
    @TableField("num_eight")
    private String numEight;

    @ApiModelProperty("值9")
    @TableField("num_nine")
    private String numNine;

    @ApiModelProperty("值10")
    @TableField("num_ten")
    private String numTen;

    @ApiModelProperty("值11")
    @TableField("num_ten_one")
    private String numTenOne;

    @ApiModelProperty("值12")
    @TableField("num_ten_two")
    private String numTenTwo;

    @ApiModelProperty("值13")
    @TableField("num_ten_three")
    private String numTenThree;

    @ApiModelProperty("值14")
    @TableField("num_ten_four")
    private String numTenFour;

    @ApiModelProperty("值15")
    @TableField("num_ten_five")
    private String numTenFive;

    @ApiModelProperty("值16")
    @TableField("num_ten_six")
    private String numTenSix;

    @ApiModelProperty("值17")
    @TableField("num_ten_seven")
    private String numTenSeven;

    @ApiModelProperty("值18")
    @TableField("num_ten_eight")
    private String numTenEight;

    @ApiModelProperty("值19")
    @TableField("num_ten_nine")
    private String numTenNine;

    @ApiModelProperty("值20")
    @TableField("num_twenty")
    private String numTwenty;

    @ApiModelProperty("值21")
    @TableField("num_twenty_one")
    private String numTwentyOne;

    @ApiModelProperty("值22")
    @TableField("num_twenty_two")
    private String numTwentyTwo;

    @ApiModelProperty("是否合格（1：合格；2：不合格）")
    @TableField("qualified")
    private String qualified;

    @ApiModelProperty("不合格说明")
    @TableField("no_qualified_remark")
    private String noQualifiedRemark;

    @ApiModelProperty("备注")
    @TableField("remark")
    private String remark;

    @ApiModelProperty("是否删除（0：未删除，1：已删除）")
    @TableField("del_flag")
    private String delFlag;

    @ApiModelProperty("导入道岔顺序")
    @TableField("sort")
    private Integer sort;

}
