package org.jeecg.modules.checkData.mapper;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.jeecg.modules.checkData.dto.MovementAdditiveInfoDTO;
import org.jeecg.modules.checkData.dto.MovementRecordsMasterDTO;
import org.jeecg.modules.checkData.entity.MovementRecordsMaster;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import org.jeecg.modules.checkData.vo.MovementAdditiveInfoVO;
import org.jeecg.modules.checkData.vo.MovementRecordsMasterVO;
import org.jeecg.modules.homePage.vo.ToDoDetailVO;

import java.math.BigDecimal;
import java.util.List;

/**
 * <p>
 * 动静态几何尺寸数据主表	 Mapper 接口
 * </p>
 *
 * @author hkl
 * @since 2023-07-11
 */
public interface MovementRecordsMasterMapper extends BaseMapper<MovementRecordsMaster> {
    /**
     * 动静态几何尺寸列表-分页列表查询
     *
     * @param pageData
     * @param dto
     * @return
     */
    Page<MovementRecordsMasterVO> queryPageList(Page<MovementRecordsMasterVO> pageData, MovementRecordsMasterDTO dto);

    /**
     * 查询添乘仪详情
     *
     * @param pageData
     * @param dto
     * @return
     */
    Page<MovementAdditiveInfoVO> queryPageAdditiveInfoList(Page<MovementAdditiveInfoVO> pageData, MovementAdditiveInfoDTO dto);


    List<ToDoDetailVO> getTodoList(String currentUserId);
}
