package org.jeecg.modules.checkData.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.IService;
import org.jeecg.modules.checkData.dto.MovementAdditiveInfoDTO;
import org.jeecg.modules.checkData.dto.MovementRecordsMasterDTO;
import org.jeecg.modules.checkData.entity.MovementRecordsMaster;
import org.jeecg.modules.checkData.vo.MovementAdditiveInfoVO;
import org.jeecg.modules.checkData.vo.MovementRecordsMasterVO;
import org.jeecg.modules.homePage.vo.ToDoDetailVO;

import java.util.List;

/**
 * <p>
 * 动静态几何尺寸数据主表	 服务类
 * </p>
 *
 * @author hkl
 * @since 2023-07-11
 */
public interface IMovementRecordsMasterService extends IService<MovementRecordsMaster> {
    /**
     * 动静态几何尺寸列表-分页列表查询
     *
     * @param pageData
     * @param dto
     * @return
     */
    Page<MovementRecordsMasterVO> queryPageList(Page<MovementRecordsMasterVO> pageData, MovementRecordsMasterDTO dto);

    /**
     * 查询添乘仪详情
     *
     * @param pageData
     * @param dto
     * @return
     */
    Page<MovementAdditiveInfoVO> queryPageAdditiveInfoList(Page<MovementAdditiveInfoVO> pageData, MovementAdditiveInfoDTO dto);

    /**
     * 获取代办列表
     * @param currentUserId
     * @return
     */
    List<ToDoDetailVO> getTodoList(String currentUserId);
}
