package org.jeecg.modules.checkData.vo;

import com.baomidou.mybatisplus.annotation.TableField;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;

@Data
@ApiModel(value = "RailWearRecordDetailVO对象", description = "钢轨伤损情况检查详情")
public class CorrugationRecordDetailVO {
    private static final long serialVersionUID = 1L;

    @ApiModelProperty("主键")
    private String id;

    @ApiModelProperty("检查设备id")
    private String deviceProjectId;

    @ApiModelProperty("检查设备code")
    private String deviceProjectCode;

    @ApiModelProperty("检查设备类型（1-钢轨,2-曲线,3-竖曲线,4-道岔）")
    private Integer deviceProjectType;

    @ApiModelProperty("曲线半径")
    private BigDecimal curveRadius;

    @ApiModelProperty("曲线超高")
    private BigDecimal superHigh;

    @ApiModelProperty("曲线长度")
    private BigDecimal curveLen;

    @ApiModelProperty("检查项目-波段-谷深(10-30)")
    private BigDecimal checkBandOne;

    @ApiModelProperty("检查项目-波段-谷深(30-100)")
    private BigDecimal checkBandTwo;

    @ApiModelProperty("检查项目-波段-谷深(100-300)")
    private BigDecimal checkBandThree;

    @ApiModelProperty("检查项目-波段-谷深(300-1000)")
    private BigDecimal checkBandFour;

    @ApiModelProperty("超限记录")
    private String overrunInfo;
}
