package org.jeecg.modules.checkData.vo;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.math.BigDecimal;
import java.util.Date;

/**
 * <p>
 * 动静态几何尺寸对应的添乘仪详情表
 * </p>
 *
 * @author hkl
 * @since 2023-07-17
 */
@Data
public class MovementAdditiveInfoVO {


    private static final long serialVersionUID = 1L;

    @ApiModelProperty("主键")
    private String id;

    @ApiModelProperty("创建人")
    private String createBy;

    @ApiModelProperty("创建日期")
    @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private Date createTime;

    @ApiModelProperty("更新人")
    private String updateBy;

    @ApiModelProperty("更新时间")
    @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private Date updateTime;

    @ApiModelProperty("动静态几何尺寸数据主表主键-》外键")
    private String movementMasterId;

    @ApiModelProperty("测点里程")
    private BigDecimal pointMileage;

    @ApiModelProperty("水平加速度")
    private BigDecimal zontalSpeed;

    @ApiModelProperty("水平加速度等级")
    private Integer zontalSpeedLevel;

    @ApiModelProperty("垂直加速度")
    private BigDecimal verticalSpeed;

    @ApiModelProperty("垂直加速度等级")
    private Integer verticalSpeedLevel;

    @ApiModelProperty("速度")
    private BigDecimal speed;

    @ApiModelProperty("手动标记")
    private String mark;

    @ApiModelProperty("是否删除（0：未删除；1：已删除）")
    private String delFlag;

    @ApiModelProperty("排序字段")
    private Integer infoSort;


}
