package org.jeecg.modules.checkData.vo;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.Getter;
import lombok.Setter;

/**
 * <p>
 * 检查数据-动静态几何尺寸数据-轨检仪静态检查数据-检查项目
 * </p>
 *
 * @author hkl
 * @since 2023-07-16
 */
@Data
@ApiModel(value = "RailInspectionEquipmentItemVO对象", description = "检查数据-动静态几何尺寸数据-轨检仪静态检查数据-检查项目")
public class RailInspectionEquipmentItemVO {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty("主键")
    private String id;

    @ApiModelProperty("检查项目Id")
    private String itemId;

    @ApiModelProperty("轨检仪静态检查数据id")
    private String railInspectionEquipmentId;

    @ApiModelProperty("检查起始里程（m）")
    private BigDecimal courseStartingMileage;

    @ApiModelProperty("检查终点里程(m)")
    private BigDecimal courseEndMileage;

    @ApiModelProperty("曲线半径（m）")
    private BigDecimal curveRadius;

    @ApiModelProperty("超高（mm）")
    private BigDecimal superHigh;

    @ApiModelProperty("加宽（mm）")
    private BigDecimal widen;

    @ApiModelProperty("顺坡率（‰）")
    private BigDecimal slopeRatio;

    @ApiModelProperty("长度（m）")
    private BigDecimal longExtent;

    @ApiModelProperty("备注")
    private String remark;

    @ApiModelProperty("导入排序")
    private Integer sort;

}
