package org.jeecg.modules.deviceAsset.controller;


import cn.hutool.core.util.ObjectUtil;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.jeecg.common.api.vo.Result;
import org.jeecg.common.aspect.annotation.AutoLog;
import org.jeecg.common.exception.JeecgBootException;
import org.jeecg.common.system.base.controller.JeecgController;
import org.jeecg.modules.deviceAsset.dto.RailManagementDTO;
import org.jeecg.modules.deviceAsset.entity.RailManagement;
import org.jeecg.modules.deviceAsset.service.IRailManagementService;
import org.jeecg.modules.deviceAsset.vo.RailManagementVO;
import org.springframework.web.bind.annotation.*;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * <p>
 * 资产管理-钢轨管理 前端控制器
 * </p>
 *
 * @author hkl
 * @since 2023-07-06
 */
@RestController
@RequestMapping("/deviceAsset/railManagement")
@Api(tags = "资产管理-钢轨管理")
public class RailManagementController extends JeecgController<RailManagement, IRailManagementService> {


    @AutoLog(value = "资产管理-钢轨管理-分页列表查询")
    @ApiOperation(value = "资产管理-道岔管理-分页列表查询", notes = "资产管理-道岔管理-分页列表查询")
    @GetMapping(value = "/list")
    public Result<IPage<RailManagementVO>> queryPageList(@RequestParam(name = "pageNo", defaultValue = "1") Integer pageNo,
                                                         @RequestParam(name = "pageSize", defaultValue = "10") Integer pageSize,
                                                         RailManagementDTO dto) {
        Page<RailManagementVO> pageData = new Page<>(pageNo, pageSize);
        pageData = this.service.queryPageList(pageData, dto);
        return Result.OK(pageData);
    }


    @AutoLog(value = "资产管理-钢轨管理-编辑")
    @ApiOperation(value = "资产管理-钢轨管理-编辑", notes = "资产管理-钢轨管理-编辑")
    @PostMapping(value = "/edit")
    public Result<String> edit(@RequestBody RailManagement railManagement) {
        this.service.verifyUnitDeviceConflicts(
                railManagement.getId(),
                railManagement.getLightRailId(),
                railManagement.getLineAliasId(),
                railManagement.getStartingMileage(),
                railManagement.getEndMileage()
        );


        this.service.edit(railManagement);

        return Result.OK("编辑成功!");
    }

    @AutoLog(value = "资产管理-钢轨管理-通过id删除")
    @ApiOperation(value = "资产管理-钢轨管理-通过id删除", notes = "资产管理-钢轨管理-通过id删除")
    @GetMapping(value = "/delete")
    public Result<String> delete(@RequestParam(name = "id", required = true) String id) {
        this.service.removeById(id);
        return Result.OK("删除成功!");
    }

    @AutoLog(value = "资产管理-钢轨管理-批量删除")
    @ApiOperation(value = "资产管理-钢轨管理-批量删除", notes = "资产管理-钢轨管理-批量删除")
    @GetMapping(value = "/deleteBatch")
    public Result<String> deleteBatch(@RequestParam(name = "ids", required = true) String ids) {
        this.service.removeByIds(Arrays.asList(ids.split(",")));
        return Result.OK("批量删除成功!");
    }


    @AutoLog(value = "资产管理-钢轨管理-智能生成")
    @ApiOperation(value = "资产管理-钢轨管理-智能生成", notes = "资产管理-钢轨管理-智能生成")
    @GetMapping(value = "/intelligentGeneration")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "lightRailId", value = "线路id"),
            @ApiImplicitParam(name = "lineAliasId", value = "线别id")
    })
    public Result<String> intelligentGeneration(String lightRailId, String lineAliasId) {
        this.service.intelligentGeneration(lightRailId, lineAliasId);
        return Result.OK("生成成功");
    }


    @AutoLog(value = "资产管理-钢轨管理-校验钢轨编码重复")
    @ApiOperation(value = "资产管理-钢轨管理-校验钢轨编码重复", notes = "资产管理-钢轨管理-校验钢轨编码重复")
    @GetMapping(value = "/checkRailCodeRepeat")
    public Result<String> checkRailCodeRepeat(String id, String lightRailId, String railCode) {
        Long count = 0L;
        if (ObjectUtil.isNotEmpty(lightRailId)) {
            count = this.service.checkRailCodeRepeat(id, lightRailId, railCode);
        }
        if (count > 0) {
            throw JeecgBootException.error("");
        }
        return Result.OK("未重复");
    }

    @AutoLog(value = "资产管理-钢轨管理-获取新增时候参数")
    @ApiOperation(value = "资产管理-钢轨管理-获取新增时候参数", notes = "资产管理-钢轨管理-获取新增时候参数")
    @GetMapping(value = "/getAddParams")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "lightRailId", value = "线路id"),
            @ApiImplicitParam(name = "lineAliasId", value = "线别id"),
            @ApiImplicitParam(name = "sectionId", value = "区间id"),
    })
    public Result<Map<String, Object>> getAddParams(String lightRailId, String lineAliasId, String sectionId) {
        // 1.如果没有钢轨数据，返回区间里程
        // 2.如果有钢轨有空隙就返回空隙
        // 3.如果钢轨没有空隙返回区间里程
        // 4.如果返回过长的里程
        Map<String, Object> map = this.service.getAddParams(lightRailId, lineAliasId, sectionId);

        return Result.OK(map);
    }


}
