package org.jeecg.modules.deviceAsset.controller;


import cn.hutool.core.util.ObjectUtil;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.jeecg.common.api.vo.Result;
import org.jeecg.common.aspect.annotation.AutoLog;
import org.jeecg.common.exception.JeecgBootException;
import org.jeecg.common.util.UUIDGenerator;
import org.jeecg.modules.deviceAsset.dto.FastenerManagementDTO;
import org.jeecg.modules.deviceAsset.dto.SignBoardManagementDTO;
import org.jeecg.modules.deviceAsset.entity.FastenerManagement;
import org.jeecg.modules.deviceAsset.entity.SignBoardManagement;
import org.jeecg.modules.deviceAsset.entity.TrackBedManagement;
import org.jeecg.modules.deviceAsset.service.*;
import org.jeecg.modules.deviceAsset.vo.FastenerManagementVO;
import org.jeecg.modules.deviceAsset.vo.SignBoardManagementVO;
import org.jeecg.modules.subwayNetwork.entity.LightRail;
import org.jeecg.modules.subwayNetwork.entity.LineAlias;
import org.jeecg.modules.subwayNetwork.service.ILightRailService;
import org.jeecg.modules.subwayNetwork.service.ILineAliasService;
import org.springframework.web.bind.annotation.*;

import org.jeecg.common.system.base.controller.JeecgController;

import javax.annotation.Resource;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.List;

/**
 * <p>
 * 资产管理-轨行区标识牌管理 前端控制器
 * </p>
 *
 * @author hkl
 * @since 2023-07-06
 */
@RestController
@RequestMapping("/deviceAsset/signBoardManagement")
@Api(tags = "资产管理-轨行区标识管理")
public class SignBoardManagementController extends JeecgController<SignBoardManagement, ISignBoardManagementService> {
    @Resource
    private ILightRailService lightRailService;
    @Resource
    private ILineAliasService lineAliasService;


    @AutoLog(value = "资产管理-轨行区标识管理 -分页列表查询")
    @ApiOperation(value = "资产管理-道岔管理-分页列表查询", notes = "资产管理-道岔管理-分页列表查询")
    @GetMapping(value = "/list")
    public Result<IPage<SignBoardManagementVO>> queryPageList(@RequestParam(name = "pageNo", defaultValue = "1") Integer pageNo,
                                                              @RequestParam(name = "pageSize", defaultValue = "10") Integer pageSize,
                                                              SignBoardManagementDTO dto) {
        Page<SignBoardManagementVO> pageData = new Page<>(pageNo, pageSize);
        pageData = this.service.queryPageList(pageData, dto);
        return Result.OK(pageData);
    }


    @AutoLog(value = "资产管理-轨行区标识管理-编辑")
    @ApiOperation(value = "资产管理-轨行区标识管理-编辑", notes = "资产管理-轨行区标识管理-编辑")
    @PostMapping(value = "/edit")
    public Result<String> edit(@RequestBody SignBoardManagement signBoardManagement) {
        // 1.验证是否超出线路的里程
        LightRail lightRail = lightRailService.getById(signBoardManagement.getLightRailId());
        LineAlias lineAlias = lineAliasService.getById(signBoardManagement.getLineAliasId());
        BigDecimal lightRailEndMileage = lightRail.getUpLineMileage();
        if (lineAlias.getLineAliasName().contains("下行")) {
            lightRailEndMileage = lightRail.getDownLineMileage();
        }
        if (signBoardManagement.getMileage().compareTo(lightRailEndMileage) > 0) {
            throw JeecgBootException.error("轨行区标识牌超过:" + lightRail.getRailLineName() + "的" + lineAlias.getLineAliasName() + "的结束里程【" + lightRailEndMileage + "】");
        }

        SignBoardManagement existSignBoardManagement = this.service.lambdaQuery()
                .eq(SignBoardManagement::getSectionId, signBoardManagement.getSectionId())
                .eq(SignBoardManagement::getLineAliasId, signBoardManagement.getLineAliasId())
                .eq(SignBoardManagement::getMileage, signBoardManagement.getMileage())
                .ne(ObjectUtil.isNotEmpty(signBoardManagement.getId()), SignBoardManagement::getId, signBoardManagement.getId())
                .last("limit 1")
                .one();
        if (existSignBoardManagement != null) {
            throw JeecgBootException.error("轨行区标识牌已存在，和轨行区标识牌【编号:" + existSignBoardManagement.getSignBoardCode() + "】里程冲突");
        }


        if (ObjectUtil.isEmpty(signBoardManagement.getId())) {
            signBoardManagement.setId(UUIDGenerator.generate());
            this.service.save(signBoardManagement);
        } else {
            this.service.updateById(signBoardManagement);
        }

        return Result.OK("编辑成功!");
    }

    /**
     * 通过id删除
     *
     * @param id
     * @return
     */
    @AutoLog(value = "资产管理-轨行区标识管理-通过id删除")
    @ApiOperation(value = "资产管理-轨行区标识管理-通过id删除", notes = "资产管理-轨行区标识管理-通过id删除")
    @GetMapping(value = "/delete")
    public Result<String> delete(@RequestParam(name = "id", required = true) String id) {


        this.service.removeById(id);
        return Result.OK("删除成功!");
    }

    /**
     * 批量删除
     *
     * @param ids
     * @return
     */
    @AutoLog(value = "资产管理-轨行区标识管理-批量删除")
    @ApiOperation(value = "资产管理-轨行区标识管理-批量删除", notes = "资产管理-轨行区标识管理-批量删除")
    @GetMapping(value = "/deleteBatch")
    public Result<String> deleteBatch(@RequestParam(name = "ids", required = true) String ids) {
        this.service.removeByIds(Arrays.asList(ids.split(",")));
        return Result.OK("批量删除成功!");
    }

    @AutoLog(value = "资产管理-轨行区标识管理-校验轨行区标识牌编码重复")
    @ApiOperation(value = "资产管理-轨行区标识管理-校验轨行区标识牌编码重复", notes = "资产管理-轨行区标识管理-校验轨行区标识牌编码重复")
    @GetMapping(value = "/checkSignBoardCodeRepeat")
    public Result<String> checkSignBoardCodeRepeat(String id, String lightRailId, String signBoardCode) {
        Long count = 0L;
        if (ObjectUtil.isNotEmpty(lightRailId)) {
            count = this.service.checkSignBoardCodeRepeat(id, lightRailId, signBoardCode);
        }
        if (count > 0) {
            throw JeecgBootException.error("");
        }
        return Result.OK("未重复");
    }
}
