package org.jeecg.modules.deviceAsset.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import java.io.Serializable;
import java.util.Date;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

/**
 * <p>
 * 资产管理-轨枕管理
 * </p>
 *
 * @author hkl
 * @since 2023-07-06
 */
@Getter
@Setter
@TableName("t_da_sleeper_management")
@ApiModel(value = "SleeperManagement对象", description = "资产管理-轨枕管理")
public class SleeperManagement implements Serializable {

    private static final long serialVersionUID = 1L;

    @TableField("id")
    private String id;

    @ApiModelProperty("创建人")
    @TableField("create_by")
    private String createBy;

    @ApiModelProperty("创建日期")
    @TableField("create_time")
    private Date createTime;

    @ApiModelProperty("更新人")
    @TableField("update_by")
    private String updateBy;

    @ApiModelProperty("更新时间")
    @TableField("update_time")
    private Date updateTime;

    @ApiModelProperty("轨枕编码")
    @TableField("sleeper_code")
    private String sleeperCode;

    @ApiModelProperty("轨枕数量")
    @TableField("sleeper_num")
    private Integer sleeperNum;

    @ApiModelProperty("轨枕类型")
    @TableField("sleeper_type")
    private String sleeperType;

    @ApiModelProperty("区间id")
    @TableField("section_id")
    private String sectionId;

    @ApiModelProperty("线别id")
    @TableField("line_alias_id")
    private String lineAliasId;

    @ApiModelProperty("道床id")
    @TableField("track_bed_id")
    private String trackBedId;


}
