package org.jeecg.modules.deviceAsset.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.Getter;
import lombok.Setter;

/**
 * <p>
 * 资产管理-道床管理
 * </p>
 *
 * @author hkl
 * @since 2023-07-06
 */
@Data
@TableName("t_da_track_bed_management")
@ApiModel(value = "TrackBedManagement对象", description = "资产管理-道床管理")
public class TrackBedManagement implements Serializable {

    private static final long serialVersionUID = 1L;

    @TableField("id")
    private String id;

    @ApiModelProperty("创建人")
    @TableField("create_by")
    private String createBy;

    @ApiModelProperty("创建日期")
    @TableField("create_time")
    private Date createTime;

    @ApiModelProperty("更新人")
    @TableField("update_by")
    private String updateBy;

    @ApiModelProperty("更新时间")
    @TableField("update_time")
    private Date updateTime;

    @ApiModelProperty("道床编号")
    @TableField("track_bed_code")
    private String trackBedCode;

    @ApiModelProperty("道床类型")
    @TableField("track_bed_type")
    private String trackBedType;

    @ApiModelProperty("区间id")
    @TableField("section_id")
    private String sectionId;

    @ApiModelProperty("线别id")
    @TableField("line_alias_id")
    private String lineAliasId;

    @ApiModelProperty("起始里程")
    @TableField("starting_mileage")
    private BigDecimal startingMileage;

    @ApiModelProperty("结束里程")
    @TableField("end_mileage")
    private BigDecimal endMileage;

    @ApiModelProperty("道床长度=结束里程-起始里程")
    @TableField("track_bed_len")
    private BigDecimal trackBedLen;

    @ApiModelProperty("备注")
    @TableField("remark")
    private String remark;

    @ApiModelProperty(value = "线路id")
    @TableField(exist = false)
    private String lightRailId;
}
