package org.jeecg.modules.deviceAsset.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.jeecg.modules.deviceAsset.dto.RailManagementDTO;
import org.jeecg.modules.deviceAsset.entity.RailManagement;
import com.baomidou.mybatisplus.extension.service.IService;
import org.jeecg.modules.deviceAsset.vo.RailManagementVO;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;

/**
 * <p>
 * 资产管理-钢轨管理 服务类
 * </p>
 *
 * @author hkl
 * @since 2023-07-06
 */
public interface IRailManagementService extends IService<RailManagement> {

    Page<RailManagementVO> queryPageList(Page<RailManagementVO> pageData, RailManagementDTO dto);

    void edit(RailManagement railManagement);

    void intelligentGeneration(String lightRailId, String lineAliasId);

    /**
     * 获取线路的特殊钢轨
     *
     * @param lineAliasId 线别ID
     */
    List<Map<String, Object>> getLineSpecialRail(String lightRailId, String lineAliasId);

    Long checkRailCodeRepeat(String id, String lightRailId, String railCode);

    Map<String, Object> getAddParams(String lightRailId, String lineAliasId, String sectionId);

    /**
     * 验证单元设备是否冲突
     */
    void verifyUnitDeviceConflicts(String unitDeviceId, String lightRailId, String lineAliasId, BigDecimal startMileage, BigDecimal endMileage);
}
