package org.jeecg.modules.deviceAsset.vo;

import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

/**
 * <p>
 * 资产管理-曲线管理
 * </p>
 *
 * @author hkl
 * @since 2023-07-06
 */
@Getter
@Setter
public class CurveManagementQueryVO implements Serializable {

    private static final long serialVersionUID = 1L;

    private String id;

    @ApiModelProperty("创建人")
    private String createBy;

    @ApiModelProperty("创建日期")
    private Date createTime;

    @ApiModelProperty("更新人")
    private String updateBy;

    @ApiModelProperty("更新时间")
    private Date updateTime;

    @ApiModelProperty("曲线编号")
    private String curveCode;

    @ApiModelProperty("曲线偏角a(°′″)")
    private String curveDeflectionAngle;

    @ApiModelProperty(value = "曲线半径R(m)")
    private BigDecimal curveRadius;

    @ApiModelProperty(value = "缓和曲线长I(m)")
    private String transitionCurveLen;

    @ApiModelProperty("切线长T(m)")
    private BigDecimal tangentLen;

    @ApiModelProperty("曲线长L(m)")
    private BigDecimal curveLen;

    @ApiModelProperty("直缓（直圆）里程ZH(ZY)")
    private BigDecimal curveMileageZh;

    @ApiModelProperty("缓圆里程(HY)")
    private BigDecimal curveMileageHy;

    @ApiModelProperty("圆缓里程(YH)")
    private BigDecimal curveMileageYh;

    @ApiModelProperty("缓直（圆直）里程HZ(YZ)")
    private BigDecimal curveMileageHz;

    @ApiModelProperty("超高H(mm)")
    private BigDecimal superHigh;

    @ApiModelProperty("线路Id")
    private String lightRailId;

    @ApiModelProperty("线路名称")
    private String lightRailName;

    @ApiModelProperty("区间id")
    private String sectionId;

    @ApiModelProperty("区间名称")
    private String sectionName;

    @ApiModelProperty("线别id")
    private String lineAliasId;

    @ApiModelProperty("线别名称")
    private String lineAliasName;

    @ApiModelProperty("备注")
    private String remark;


}
