package org.jeecg.modules.deviceAsset.vo;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.Getter;
import lombok.Setter;

/**
 * <p>
 * 资产管理-轨枕管理
 * </p>
 *
 * @author hkl
 * @since 2023-07-06
 */
@Data
@ApiModel(value = "SleeperManagement对象", description = "资产管理-轨枕管理")
public class SleeperManagementVO implements Serializable {

    private static final long serialVersionUID = 1L;

    @TableField("id")
    private String id;

    @ApiModelProperty("创建人")
    private String createBy;

    @ApiModelProperty("创建日期")
    private Date createTime;

    @ApiModelProperty("更新人")
    private String updateBy;

    @ApiModelProperty("更新时间")
    private Date updateTime;

    @ApiModelProperty("轨枕编码")
    private String sleeperCode;

    @ApiModelProperty("轨枕数量")
    private Integer sleeperNum;

    @ApiModelProperty("轨枕类型")
    private String sleeperType;

    @ApiModelProperty("线路id")
    private String lightRailId;

    @ApiModelProperty("线路名称")
    private String lightRailName;

    @ApiModelProperty("区间id")
    private String sectionId;

    @ApiModelProperty("区间名称")
    private String sectionName;

    @ApiModelProperty("线别id")
    private String lineAliasId;

    @ApiModelProperty("线别名称")
    private String lineAliasName;

    @ApiModelProperty("道床id")
    private String trackBedId;
    
    @ApiModelProperty("道床编号")
    private String trackBedCode;

    @ApiModelProperty("起始里程")
    private BigDecimal startingMileage;

    @ApiModelProperty("结束里程")
    private BigDecimal endMileage;

    @ApiModelProperty("道床长度=结束里程-起始里程")
    private BigDecimal trackBedLen;

    @ApiModelProperty("备注")
    private String remark;

}
