package org.jeecg.modules.deviceAsset.vo;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

/**
 * <p>
 * 资产管理-道床管理
 * </p>
 *
 * @author hkl
 * @since 2023-07-06
 */
@Data
public class TrackBedManagementVO implements Serializable {

    private static final long serialVersionUID = 1L;

    @TableField("id")
    private String id;

    @ApiModelProperty("创建人")
    private String createBy;

    @ApiModelProperty("创建日期")
    private Date createTime;

    @ApiModelProperty("更新人")
    private String updateBy;

    @ApiModelProperty("更新时间")
    private Date updateTime;

    @ApiModelProperty("道床编号")
    private String trackBedCode;

    @ApiModelProperty("道床类型")
    private String trackBedType;

    @ApiModelProperty("线路Id")
    private String lightRailId;

    @ApiModelProperty("线路名称")
    private String lightRailName;

    @ApiModelProperty("区间id")
    private String sectionId;

    @ApiModelProperty("区间名称")
    private String sectionName;

    @ApiModelProperty("线别id")
    private String lineAliasId;

    @ApiModelProperty("线别名称")
    private String lineAliasName;

    @ApiModelProperty("起始里程")
    private BigDecimal startingMileage;

    @ApiModelProperty("结束里程")
    private BigDecimal endMileage;

    @ApiModelProperty("道床长度=结束里程-起始里程")
    private BigDecimal trackBedLen;

    @ApiModelProperty("备注")
    private String remark;

}
