package org.jeecg.modules.diseaseAnalysis.controller;


import cn.hutool.core.convert.Convert;
import cn.hutool.core.util.ObjectUtil;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import io.swagger.annotations.ApiOperation;
import org.jeecg.common.api.vo.Result;
import org.jeecg.common.aspect.annotation.AutoLog;
import org.jeecg.common.exception.JeecgBootException;
import org.jeecg.modules.diseaseAnalysis.dto.*;
import org.jeecg.modules.diseaseAnalysis.entity.AnalysisLineBatch;
import org.jeecg.modules.diseaseAnalysis.service.IAnalysisLineBatchService;
import org.jeecg.modules.diseaseAnalysis.vo.*;
import org.springframework.web.bind.annotation.*;

import org.jeecg.common.system.base.controller.JeecgController;

import java.util.*;
import java.util.stream.Collectors;

/**
 * <p>
 * 线路质量分析	-分析批次表 前端控制器
 * </p>
 *
 * @author hkl
 * @since 2024-07-19
 */
@RestController
@RequestMapping("/analysisLineBatch")
public class AnalysisLineBatchController extends JeecgController<AnalysisLineBatch, IAnalysisLineBatchService> {
    /**
     * 线路质量分析-其他病害分析-检查记录(除去线路巡查)-分页列表查询
     *
     * @param pageNo
     * @param pageSize
     * @param dto
     * @return
     */
    @AutoLog(value = "线路质量分析-其他病害分析-检查记录(除去线路巡查)-分页列表查询")
    @ApiOperation(value = "线路质量分析-其他病害分析-检查记录(除去线路巡查)-分页列表查询", notes = "线路质量分析-其他病害分析-检查记录(除去线路巡查)-分页列表查询")
    @GetMapping(value = "/ekList")
    public Result<IPage<EkRecordsMasterCheckVO>> queryPageEkList(@RequestParam(name = "pageNo", defaultValue = "1") Integer pageNo,
                                                                 @RequestParam(name = "pageSize", defaultValue = "10") Integer pageSize,
                                                                 EkRecordsMasterCheckDTO dto) {
        Page<EkRecordsMasterCheckVO> pageData = new Page<>(pageNo, pageSize);
        pageData = this.service.queryPageEkList(pageData, dto);
        return Result.OK(pageData);
    }

    /**
     * 线路质量分析-其他病害分析-线路巡查检查记录-分页列表查询
     *
     * @param pageNo
     * @param pageSize
     * @param dto
     * @return
     */
    @AutoLog(value = "线路质量分析-其他病害分析-线路巡查检查记录-分页列表查询")
    @ApiOperation(value = "线路质量分析-其他病害分析-线路巡查检查记录-分页列表查询", notes = "线路质量分析-其他病害分析-线路巡查检查记录-分页列表查询")
    @GetMapping(value = "/ekPatrolList")
    public Result<IPage<EkRecordPatrolMasterVO>> queryPageEkPatrolList(@RequestParam(name = "pageNo", defaultValue = "1") Integer pageNo,
                                                                       @RequestParam(name = "pageSize", defaultValue = "10") Integer pageSize,
                                                                       EkRecordsMasterCheckDTO dto) {
        Page<EkRecordPatrolMasterVO> pageData = new Page<>(pageNo, pageSize);
        pageData = this.service.queryPageEkPatrolList(pageData, dto);
        return Result.OK(pageData);
    }

    /**
     * 线路质量分析-其他病害分析-分页列表查询
     *
     * @param pageNo
     * @param pageSize
     * @param dto
     * @return
     */
    @AutoLog(value = "线路质量分析-其他病害分析-分页列表查询")
    @ApiOperation(value = "线路质量分析-其他病害分析-分页列表查询", notes = "线路质量分析-其他病害分析-分页列表查询")
    @GetMapping(value = "/getPageList")
    public Result<IPage<AnalysisLineBatchVO>> getPageList(@RequestParam(name = "pageNo", defaultValue = "1") Integer pageNo,
                                                          @RequestParam(name = "pageSize", defaultValue = "10") Integer pageSize,
                                                          AnalysisLineBatchDTO dto) {
        Page<AnalysisLineBatchVO> pageData = new Page<>(pageNo, pageSize);
        pageData = this.service.getPageList(pageData, dto);
        // 查询明细
        List<AnalysisLineBatchVO> records = pageData.getRecords();
        if (ObjectUtil.isNotEmpty(records)) {
            // 新增明细
            List<String> analysisLineBatchIds = records.stream().map(AnalysisLineBatchVO::getId).collect(Collectors.toList());
            List<AnalysisLineBatchCheckDataMapVO> checkBatchList = this.service.listRecordDetail(analysisLineBatchIds);
            if (ObjectUtil.isNotEmpty(checkBatchList)) {
                Map<String, List<AnalysisLineBatchCheckDataMapVO>> analysisBatchMap = checkBatchList.stream().collect(Collectors.groupingBy(AnalysisLineBatchCheckDataMapVO::getAnalysisBatchId));
                records.forEach(record -> {
                    List<AnalysisLineBatchCheckDataMapVO> checkBatchVOS = analysisBatchMap.get(record.getId());
                    record.setCheckBatchList(checkBatchVOS);
                });
            }
            // 获取是否可编辑列表
            List<Map<String, Object>> isEditList = this.service.getIsEditList(analysisLineBatchIds);
            if (ObjectUtil.isNotEmpty(isEditList)) {
                Map<String, Boolean> isEditMap = isEditList.stream().collect(
                        Collectors.toMap(
                                key -> key.get("id").toString(),
                                value -> !Convert.toBool(value.get("isEdit"))
                        )
                );
                records.forEach(record -> {
                    record.setEdit(isEditMap.get(record.getId()));
                });
            }
        }
        return Result.OK(pageData);
    }

    /**
     * 线路质量分析-其他病害分析-单元查询-分页列表查询
     *
     * @param pageNo
     * @param pageSize
     * @param dto
     * @return
     */
    @AutoLog(value = "线路质量分析-其他病害分析-单元查询-分页列表查询")
    @ApiOperation(value = "线路质量分析-其他病害分析-单元查询-分页列表查询", notes = "线路质量分析-其他病害分析-单元查询-分页列表查询")
    @GetMapping(value = "/getInfoPageList")
    public Result<IPage<AnalysisLineBatchUnitDeviceVO>> getInfoPageList(@RequestParam(name = "pageNo", defaultValue = "1") Integer pageNo,
                                                                        @RequestParam(name = "pageSize", defaultValue = "10") Integer pageSize,
                                                                        AnalysisLineBatchInfoDTO dto) {
        Page<AnalysisLineBatchUnitDeviceVO> pageData = new Page<>(pageNo, pageSize);
        pageData = this.service.getInfoPageList(pageData, dto);
        List<AnalysisLineBatchUnitDeviceVO> records = pageData.getRecords();
        if(CollectionUtils.isNotEmpty(records)){
            Set<String> analysisLineBatchIds = records.stream().map(AnalysisLineBatchUnitDeviceVO::getAnalysisBatchId).collect(Collectors.toSet());
            List<String> ids = new ArrayList();
            analysisLineBatchIds.forEach(id->{
                ids.add(id);
            });
            List<AnalysisLineBatchCheckDataMapVO> checkBatchList = this.service.listRecordDetail(ids);
            if (ObjectUtil.isNotEmpty(checkBatchList)) {
                Map<String, List<AnalysisLineBatchCheckDataMapVO>> analysisBatchMap = checkBatchList.stream().collect(Collectors.groupingBy(AnalysisLineBatchCheckDataMapVO::getAnalysisBatchId));
                records.forEach(record -> {
                    AnalysisLineBatchCheckDataMapVO mapVO = analysisBatchMap.get(record.getAnalysisBatchId()).get(0);
                    record.setCheckBy(mapVO.getCheckBy());
                    record.setCheckTime(mapVO.getCheckTime());
                });
            }
        }
        return Result.OK(pageData);
    }

    /**
     * 线路质量分析-其他病害分析-道岔检查单元详情检查记录查询
     *
     * @param analysisBatchId 分析批次id
     * @param ekId            检查批次id
     * @param deviceId        线路质量分析-其他病害分析-单元表id
     * @return
     */
    @AutoLog(value = "线路质量分析-其他病害分析-道岔检查单元详情检查记录查询")
    @ApiOperation(value = "线路质量分析-其他病害分析-道岔检查单元详情检查记录查询", notes = "线路质量分析-其他病害分析-道岔检查单元详情检查记录查询")
    @GetMapping(value = "/getAnalysisLineBatchUnitEkInfoList")
    public Result<List<AnalysisLineBatchUnitDeviceTurnoutInfoVO>> getAnalysisLineBatchUnitEkInfoList(@RequestParam String analysisBatchId, @RequestParam String ekId, @RequestParam String deviceId) {
        List<AnalysisLineBatchUnitDeviceTurnoutInfoVO> list = this.service.getAnalysisLineBatchUnitEkInfoList(analysisBatchId, ekId, deviceId);
        return Result.OK(list);
    }

    /**
     * 线路质量分析-其他病害分析-钢轨探伤单元详情检查记录查询
     *
     * @param analysisBatchId 分析批次id
     * @param ekId            检查批次id
     * @param deviceId        线路质量分析-其他病害分析-单元表id
     * @return
     */
    @AutoLog(value = "线路质量分析-其他病害分析-钢轨探伤单元详情检查记录查询")
    @ApiOperation(value = "线路质量分析-其他病害分析-钢轨探伤单元详情检查记录查询", notes = "线路质量分析-其他病害分析-钢轨探伤单元详情检查记录查询")
    @GetMapping(value = "/getAnalysisLineBatchUnitDeviceRailWearInfoList")
    public Result<List<AnalysisLineBatchUnitDeviceRailWearInfoVO>> getAnalysisLineBatchUnitDeviceRailWearInfoList(@RequestParam String analysisBatchId, @RequestParam String ekId, @RequestParam String deviceId) {
        List<AnalysisLineBatchUnitDeviceRailWearInfoVO> list = this.service.getAnalysisLineBatchUnitDeviceRailWearInfoList(analysisBatchId, ekId, deviceId);
        return Result.OK(list);
    }

    /**
     * 线路质量分析-其他病害分析-钢轨波磨单元详情检查记录查询
     *
     * @param analysisBatchId 分析批次id
     * @param ekId            检查批次id
     * @param deviceId        线路质量分析-其他病害分析-单元表id
     * @return
     */
    @AutoLog(value = "线路质量分析-其他病害分析-钢轨波磨单元详情检查记录查询")
    @ApiOperation(value = "线路质量分析-其他病害分析-钢轨波磨单元详情检查记录查询", notes = "线路质量分析-其他病害分析-钢轨波磨单元详情检查记录查询")
    @GetMapping(value = "/getAnalysisLineBatchUnitDeviceCorrugationInfoList")
    public Result<List<AnalysisLineBatchUnitDeviceCorrugationInfoVO>> getAnalysisLineBatchUnitDeviceCorrugationInfoList(@RequestParam String analysisBatchId, @RequestParam String ekId, @RequestParam String deviceId) {
        List<AnalysisLineBatchUnitDeviceCorrugationInfoVO> list = this.service.getAnalysisLineBatchUnitDeviceCorrugationInfoList(analysisBatchId, ekId, deviceId);
        return Result.OK(list);
    }

    /**
     * 线路质量分析-其他病害分析-曲线波磨单元详情检查记录查询
     *
     * @param analysisBatchId 分析批次id
     * @param ekId            检查批次id
     * @param deviceId        线路质量分析-其他病害分析-单元表id
     * @return
     */
    @AutoLog(value = "线路质量分析-其他病害分析-曲线波磨单元详情检查记录查询")
    @ApiOperation(value = "线路质量分析-其他病害分析-曲线波磨单元详情检查记录查询", notes = "线路质量分析-其他病害分析-曲线波磨单元详情检查记录查询")
    @GetMapping(value = "/getAnalysisLineBatchUnitDeviceCurveWearInfoList")
    public Result<List<AnalysisLineBatchUnitDeviceCurveWearInfoVO>> getAnalysisLineBatchUnitDeviceCurveWearInfoList(@RequestParam String analysisBatchId, @RequestParam String ekId, @RequestParam String deviceId) {
        List<AnalysisLineBatchUnitDeviceCurveWearInfoVO> list = this.service.getAnalysisLineBatchUnitDeviceCurveWearInfoList(analysisBatchId, ekId, deviceId);
        return Result.OK(list);
    }
    /**
     * 线路质量分析-其他病害分析-道床单元详情检查记录查询
     *
     * @param analysisBatchId 分析批次id
     * @param ekId            检查批次id
     * @param deviceId        线路质量分析-其他病害分析-单元表id
     * @return
     */
    @AutoLog(value = "线路质量分析-其他病害分析-道床单元详情检查记录查询")
    @ApiOperation(value = "线路质量分析-其他病害分析-道床单元详情检查记录查询", notes = "线路质量分析-其他病害分析-道床单元详情检查记录查询")
    @GetMapping(value = "/getAnalysisLineBatchUnitDeviceTrackBedInfoList")
    public Result<List<AnalysisLineBatchUnitDeviceTrackBedInfoVO>> getAnalysisLineBatchUnitDeviceTrackBedInfoList(@RequestParam String analysisBatchId, @RequestParam String ekId, @RequestParam String deviceId) {
        List<AnalysisLineBatchUnitDeviceTrackBedInfoVO> list = this.service.getAnalysisLineBatchUnitDeviceTrackBedInfoList(analysisBatchId, ekId, deviceId);
        return Result.OK(list);
    }
    /**
     * 线路质量分析-其他病害分析-线路巡查巡道员检查详情
     *
     * @param analysisBatchId 分析批次id
     * @param ekId            检查批次id
     * @param deviceId        线路质量分析-其他病害分析-单元表id
     * @return
     */
    @AutoLog(value = "线路质量分析-其他病害分析-线路巡查巡道员检查详情")
    @ApiOperation(value = "线路质量分析-其他病害分析-线路巡查巡道员检查详情", notes = "线路质量分析-其他病害分析-线路巡查巡道员检查详情")
    @GetMapping(value = "/getAnalysisLineBatchUnitDevicePatrolInfoList")
    public Result<List<AnalysisLineBatchUnitDevicePatrolInfoVO>> getAnalysisLineBatchUnitDevicePatrolInfoList(@RequestParam String analysisBatchId, @RequestParam String ekId, @RequestParam String deviceId) {
        List<AnalysisLineBatchUnitDevicePatrolInfoVO> list = this.service.getAnalysisLineBatchUnitDevicePatrolInfoList(analysisBatchId, ekId, deviceId);
        return Result.OK(list);
    }

    /**
     * 线路质量分析-其他病害分析-线路巡查协助巡道员检查详情
     *
     * @param analysisBatchId 分析批次id
     * @param ekId            检查批次id
     * @param deviceId        线路质量分析-其他病害分析-单元表id
     * @return
     */
    @AutoLog(value = "线路质量分析-其他病害分析-线路巡查协助巡道员检查详情")
    @ApiOperation(value = "线路质量分析-其他病害分析-线路巡查协助巡道员检查详情", notes = "线路质量分析-其他病害分析-线路巡查协助巡道员检查详情")
    @GetMapping(value = "/getAnalysisLineBatchUnitDevicePatrolAssistInfoList")
    public Result<List<AnalysisLineBatchUnitDevicePatrolAssistInfoVO>> getAnalysisLineBatchUnitDevicePatrolAssistInfoList(@RequestParam String analysisBatchId, @RequestParam String ekId, @RequestParam String deviceId) {
        List<AnalysisLineBatchUnitDevicePatrolAssistInfoVO> list = this.service.getAnalysisLineBatchUnitDevicePatrolAssistInfoList(analysisBatchId, ekId, deviceId);
        return Result.OK(list);
    }
    /**
     * 维修作业管理-选择分析批次-列表分页查询
     *
     * @param pageNo
     * @param pageSize
     * @param dto
     * @return
     */
    @AutoLog(value = "维修作业管理-选择分析批次-列表分页查询")
    @ApiOperation(value = "维修作业管理-选择分析批次-列表分页查询", notes = "维修作业管理-选择分析批次-列表分页查询")
    @GetMapping(value = "/getWorkPageList")
    public Result<IPage<AnalysisLineBatchWorkVO>> getWorkPageList(@RequestParam(name = "pageNo", defaultValue = "1") Integer pageNo,
                                                          @RequestParam(name = "pageSize", defaultValue = "10") Integer pageSize,
                                                          AnalysisLineBatchWorkDTO dto) {
        List<String> ekTypeList = new ArrayList<>();
        if (dto.getEkType().contains(",")) {
            ekTypeList = Arrays.asList(dto.getEkType().split(","));
        }
        dto.setEkTypeList(ekTypeList);
        Page<AnalysisLineBatchWorkVO> pageData = new Page<>(pageNo, pageSize);
        pageData = this.service.getWorkPageList(pageData, dto);
        return Result.OK(pageData);
    }


    //***********************************分析新增编辑接口*************************************************************************************************************
    @AutoLog(value = "其他病害分析-分析批次-新增分析批次")
    @ApiOperation(value = "其他病害分析-分析批次-新增分析批次", notes = "其他病害分析-分析批次-新增分析批次")
    @PostMapping(value = "/saveRecord")
    public Result<String> saveRecord(@RequestBody AnalysisLineBatchSaveOrUpdateDTO dto) {

        if (dto.getStartingMileage().compareTo(dto.getEndMileage()) > 0) {
            throw new JeecgBootException("起始里程不能大于结束里程");
        }
        // 去重
        AnalysisLineBatch exist = this.service.lambdaQuery().eq(AnalysisLineBatch::getAnalysisBatchCode, dto.getAnalysisBatchCode())
                .last("limit 1")
                .one();
        if (exist != null) {
            throw new JeecgBootException("【" + dto.getAnalysisBatchCode() + "】分析批次已存在");
        }

        this.service.saveRecord(dto);

        return Result.OK("操作成功");
    }

    @AutoLog(value = "其他病害分析-分析批次-更新分析批次")
    @ApiOperation(value = "其他病害分析-分析批次-更新分析批次", notes = "其他病害分析-分析批次-更新分析批次")
    @PostMapping(value = "/updateRecord")
    public Result<String> updateRecord(@RequestBody AnalysisLineBatchSaveOrUpdateDTO dto) {
        if (dto.getStartingMileage().compareTo(dto.getEndMileage()) > 0) {
            throw new JeecgBootException("起始里程不能大于结束里程");
        }
        // 去重
        AnalysisLineBatch exist = this.service.lambdaQuery()
                .eq(AnalysisLineBatch::getAnalysisBatchCode, dto.getAnalysisBatchCode())
                .ne(AnalysisLineBatch::getId, dto.getId())
                .last("limit 1")
                .one();
        if (exist != null) {
            throw new JeecgBootException("【" + dto.getAnalysisBatchCode() + "】分析批次已存在");
        }

        this.service.updateRecord(dto);

        return Result.OK("操作成功");
    }

    /**
     * 其他病害分析-分析批次-删除
     *
     * @param ids
     * @return
     */
    @AutoLog(value = "其他病害分析-分析批次-删除")
    @ApiOperation(value = "其他病害分析-分析批次-删除", notes = "其他病害分析-分析批次-删除")
    @GetMapping(value = "/deleteBatchRecord")
    public Result<String> deleteBatchRecord(@RequestParam(name = "ids", required = true) String ids, @RequestParam(name = "type", required = true) Integer type) {
        List<String> idList = new ArrayList<>();
        if (ids.contains(",")) {
            idList = Arrays.asList(ids.split(","));
        } else {
            idList.add(ids);
        }
        this.service.deleteBatchRecord(idList, type);

        return Result.OK("批量删除成功!");
    }

    @AutoLog(value = "其他病害分析-分析批次-更新分析单元标记状态")
    @ApiOperation(value = "其他病害分析-分析批次-更新分析单元标记状态", notes = "其他病害分析-分析批次-更新分析单元标记状态")
    @GetMapping(value = "/updateRecordMarkStatus")
    public Result<String> updateRecordMarkStatus(@RequestParam("id") String id, @RequestParam("status") Integer status) {
        this.service.updateRecordMarkStatus(id,status);
        return Result.OK("操作成功");
    }
}
