package org.jeecg.modules.diseaseAnalysis.dto;

import java.math.BigDecimal;
import java.util.Date;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

/**
 * <p>
 * 线路质量分析-分析批次表-检查数据关联关系表（1个分析批次有多个检查批次）
 * </p>
 *
 * @author hkl
 * @since 2024-07-19
 */
@Getter
@Setter
@ApiModel(value = "AnalysisLineBatchCheckDataMap对象", description = "线路质量分析-分析批次表-检查数据关联关系表（1个分析批次有多个检查批次）")

public class AnalysisLineBatchCheckDataMapDTO {


    private static final long serialVersionUID = 1L;

    @ApiModelProperty("主键")
    private String id;

    @ApiModelProperty("创建人")
    private String createBy;

    @ApiModelProperty("创建日期")
    private Date createTime;

    @ApiModelProperty("更新人")
    private String updateBy;

    @ApiModelProperty("更新时间")
    private Date updateTime;

    @ApiModelProperty("分析批id")
    private String analysisBatchId;

    @ApiModelProperty("分析批次号")
    private String analysisBatchCode;

    @ApiModelProperty("检查批id")
    private String ekId;

    @ApiModelProperty("检查批次号")
    private String ekCode;

    @ApiModelProperty("检查数据类型 1-道岔检查 2-钢轨常规探伤检查 3-曲线钢轨磨耗检查 4-钢轨波磨检查 5-道床检查 6-线路检查")
    private String ekType;

    @ApiModelProperty("检查日期")
    private Date checkTime;

    @ApiModelProperty("起始里程")
    private BigDecimal startingMileage;

    @ApiModelProperty("终点里程")
    private BigDecimal endMileage;

    @ApiModelProperty("分析状态 0-创建 1-分析中  99-分析完成")
    private Integer analysisStatus;

    @ApiModelProperty("备注")
    private String remark;


}
