package org.jeecg.modules.diseaseAnalysis.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.jeecg.modules.diseaseAnalysis.vo.AnalysisLineBatchCheckDataMapVO;
import org.springframework.format.annotation.DateTimeFormat;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

@Data
@ApiModel(value = "AnalysisLineBatchSaveOrUpdateDTO对象", description = "其他病害分析-分析批次保存/更新DTO")
public class AnalysisLineBatchSaveOrUpdateDTO {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty("主键")
    private String id;

    @ApiModelProperty("创建人")
    private String createBy;

    @ApiModelProperty("创建日期")
    private Date createTime;

    @ApiModelProperty("更新人")
    private String updateBy;

    @ApiModelProperty("更新时间")
    private Date updateTime;

    @ApiModelProperty("分析批次号")
    private String analysisBatchCode;

    @ApiModelProperty("所属线路id")
    private String lightRailId;

    @ApiModelProperty("所属线路名称")
    private String lightRailName;

    @ApiModelProperty("所属线别id")
    private String lineAliasId;

    @ApiModelProperty("所属线别名称")
    private String lineAliasName;

    @ApiModelProperty("分析起始里程")
    private BigDecimal startingMileage;

    @ApiModelProperty("分析终点里程")
    private BigDecimal endMileage;

    @ApiModelProperty("分析状态 0-创建 1-分析中  99-分析完成")
    private Integer analysisStatus;

    @ApiModelProperty("备注")
    private String remark;

    @ApiModelProperty("1-道岔检查 2-钢轨常规探伤检查 3-曲线钢轨磨耗检查 4-钢轨波磨检查 5-道床检查 6-线路检查）")
    private String ekType;

    @ApiModelProperty("检查数据列表")
    private List<CheckDataDTO> checkDataList;

    @Data
    @ApiModel(value = "CheckDataDTO对象", description = "其他病害分析-检查数据")
    public static class CheckDataDTO {

        @ApiModelProperty("主键")
        private String id;

        @ApiModelProperty("检查批次号")
        private String ekCode;

        @ApiModelProperty("检查批id")
        private String ekId;

        @ApiModelProperty("检查数据类型1-道岔检查 2-钢轨常规探伤检查 3-曲线钢轨磨耗检查 4-钢轨波磨检查 5-道床检查 6-线路检查）")
        private String ekType;

        @ApiModelProperty("检查日期")
        @DateTimeFormat(pattern = "yyyy-MM-dd")
        private Date checkTime;

        @ApiModelProperty("检查人")
        private String checkBy;


        @ApiModelProperty("检查起始里程")
        private BigDecimal startingMileage;

        @ApiModelProperty("检查终点里程")
        private BigDecimal endMileage;

        @ApiModelProperty("备注")
        private String remark;
    }
}
