package org.jeecg.modules.diseaseAnalysis.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.math.BigDecimal;
import java.util.Date;

/**
 * <p>
 * 线路质量分析-分析批次表-单元设备详情（1个分析批次有多个检查批次，1个检查批次有多个单位设备，1个单元设备有多个详情）---线路巡查协助巡道员详情
 * </p>
 *
 * @author hkl
 * @since 2024-07-30
 */
@Getter
@Setter
@ApiModel(value = "AnalysisLineBatchUnitDevicePatrolAssistInfo对象", description = "线路质量分析-分析批次表-单元设备详情（1个分析批次有多个检查批次，1个检查批次有多个单位设备，1个单元设备有多个详情）---线路巡查协助巡道员详情")

public class AnalysisLineBatchUnitDevicePatrolAssistInfoDTO {


    private static final long serialVersionUID = 1L;

    @ApiModelProperty("主键")
    private String id;

    @ApiModelProperty("创建人")
    private String createBy;

    @ApiModelProperty("创建日期")
    private Date createTime;

    @ApiModelProperty("更新人")
    private String updateBy;

    @ApiModelProperty("更新时间")
    private Date updateTime;

    @ApiModelProperty("分析批id")
    private String analysisBatchId;

    @ApiModelProperty("分析批次号")
    private String analysisBatchCode;

    @ApiModelProperty("设备检查记录主表id（t_ek_records_master_check、t_xd_record_patrol_master）")
    private String ekId;

    @ApiModelProperty("检查批次号（t_ek_records_master_check）")
    private String ekCode;

    @ApiModelProperty("单元表id（t_dsa_analysis_line_batch_unit_device）")
    private String deviceId;

    @ApiModelProperty("巡查区间id")
    private String subwaySectionId;

    @ApiModelProperty("巡查区间名称")
    private String subwaySectionName;

    @ApiModelProperty("线别id")
    private String lineAliasId;

    @ApiModelProperty("线别名称")
    private String lineAliasName;

    @ApiModelProperty("起始里程")
    private BigDecimal startingMileage;

    @ApiModelProperty("终点里程")
    private BigDecimal endMileage;

    @ApiModelProperty("问题记录")
    private String problemRecord;

    @ApiModelProperty("处理情况")
    private String handingLog;

    @ApiModelProperty("是否删除（0：未删除，1：已删除）")
    private String delFlag;


}
