package org.jeecg.modules.diseaseAnalysis.dto;


import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.math.BigDecimal;
import java.util.List;

/**
 * <p>
 * 线路质量分析	-分析批次表
 * </p>
 *
 * @author hkl
 * @since 2024-07-19
 */
@Getter
@Setter
@ApiModel(value = "AnalysisLineBatch对象", description = "线路质量分析	-分析批次表")

public class AnalysisLineBatchWorkDTO {


    private static final long serialVersionUID = 1L;

    @ApiModelProperty("分析批次号")
    private String analysisBatchCode;

    @ApiModelProperty("检查批次号")
    private String ekCode;

    @ApiModelProperty("所属线路id")
    private String lightRailId;

    @ApiModelProperty("所属线别id")
    private String lineAliasId;

    @ApiModelProperty("1-道岔检查 2-钢轨常规探伤检查 3-曲线钢轨磨耗检查 4-钢轨波磨检查 5-道床检查 6-线路检查）")
    private String ekType;

    @ApiModelProperty("不需要前端传递，需要后台将ekType参数处理成集合")
    private List<String> ekTypeList;

}
