package org.jeecg.modules.diseaseAnalysis.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import java.io.Serializable;
import java.util.Date;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

/**
 * <p>
 * 线路质量分析-分析批次表-单元设备详情（1个分析批次有多个检查批次，1个检查批次有多个单位设备，1个单元设备有多个详情）
 * </p>
 *
 * @author hkl
 * @since 2024-07-19
 */
@Getter
@Setter
@TableName("t_dsa_analysis_line_batch_unit_device_turnout_info")
@ApiModel(value = "AnalysisLineBatchUnitDeviceTurnoutInfo对象", description = "检查数据设备-设备检查记录数据-道岔使用情况检查数据")
public class AnalysisLineBatchUnitDeviceTurnoutInfo implements Serializable {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty("主键")
    @TableId("id")
    private String id;

    @ApiModelProperty("创建人")
    @TableField("create_by")
    private String createBy;

    @ApiModelProperty("创建日期")
    @TableField("create_time")
    private Date createTime;

    @ApiModelProperty("更新人")
    @TableField("update_by")
    private String updateBy;

    @ApiModelProperty("更新时间")
    @TableField("update_time")
    private Date updateTime;

    @ApiModelProperty("分析批id")
    @TableField("analysis_batch_id")
    private String analysisBatchId;

    @ApiModelProperty("分析批次号")
    @TableField("analysis_batch_code")
    private String analysisBatchCode;

    @ApiModelProperty("设备检查记录主表id（t_ek_records_master_check）")
    @TableField("ek_id")
    private String ekId;

    @ApiModelProperty("检查批次号（t_ek_records_master_check）")
    @TableField("ek_code")
    private String ekCode;

    @ApiModelProperty("单元表id（t_dsa_analysis_line_batch_unit_device）")
    @TableField("device_id")
    private String deviceId;

    @ApiModelProperty("设备编号(道岔表)")
    @TableField("switch_code")
    private String switchCode;

    @ApiModelProperty("设备号数(道岔表)")
    @TableField("switch_code_num")
    private String switchCodeNum;

    @ApiModelProperty("轨距水平尺编号")
    @TableField("gauge_code")
    private String gaugeCode;

    @ApiModelProperty("检查项目类型（1：轨距；2：水平；3：支距；4：轮缘槽；5：滑床板；6：顶铁；7：接头螺栓；8：护轨螺栓；9:道岔）")
    @TableField("type")
    private String type;

    @ApiModelProperty("值1")
    @TableField("num_one")
    private String numOne;

    @ApiModelProperty("值2")
    @TableField("num_two")
    private String numTwo;

    @ApiModelProperty("值3")
    @TableField("num_three")
    private String numThree;

    @ApiModelProperty("值4")
    @TableField("num_four")
    private String numFour;

    @ApiModelProperty("值5")
    @TableField("num_five")
    private String numFive;

    @ApiModelProperty("值6")
    @TableField("num_six")
    private String numSix;

    @ApiModelProperty("值7")
    @TableField("num_seven")
    private String numSeven;

    @ApiModelProperty("值8")
    @TableField("num_eight")
    private String numEight;

    @ApiModelProperty("值9")
    @TableField("num_nine")
    private String numNine;

    @ApiModelProperty("值10")
    @TableField("num_ten")
    private String numTen;

    @ApiModelProperty("值11")
    @TableField("num_ten_one")
    private String numTenOne;

    @ApiModelProperty("值12")
    @TableField("num_ten_two")
    private String numTenTwo;

    @ApiModelProperty("值13")
    @TableField("num_ten_three")
    private String numTenThree;

    @ApiModelProperty("值14")
    @TableField("num_ten_four")
    private String numTenFour;

    @ApiModelProperty("值15")
    @TableField("num_ten_five")
    private String numTenFive;

    @ApiModelProperty("值16")
    @TableField("num_ten_six")
    private String numTenSix;

    @ApiModelProperty("值17")
    @TableField("num_ten_seven")
    private String numTenSeven;

    @ApiModelProperty("值18")
    @TableField("num_ten_eight")
    private String numTenEight;

    @ApiModelProperty("值19")
    @TableField("num_ten_nine")
    private String numTenNine;

    @ApiModelProperty("值20")
    @TableField("num_twenty")
    private String numTwenty;

    @ApiModelProperty("值21")
    @TableField("num_twenty_one")
    private String numTwentyOne;

    @ApiModelProperty("值22")
    @TableField("num_twenty_two")
    private String numTwentyTwo;

    @ApiModelProperty("是否合格（1：合格；2：不合格）")
    @TableField("qualified")
    private String qualified;

    @ApiModelProperty("不合格说明")
    @TableField("no_qualified_remark")
    private String noQualifiedRemark;

    @ApiModelProperty("备注")
    @TableField("remark")
    private String remark;

    @ApiModelProperty("是否删除（0：未删除，1：已删除）")
    @TableField("del_flag")
    private String delFlag;

    @ApiModelProperty("导入道岔顺序")
    @TableField("sort")
    private Integer sort;


}
