package org.jeecg.modules.dynamicStaticAnalysis.algorithm;

import lombok.extern.slf4j.Slf4j;

/**
 * 多生产者模型-单消费者模型
 * 单消费者
 */
@Slf4j
public class SingleConsumer {
    private static AnalysisAlgorithm analysisAlgorithm;

    public static void setService(AnalysisAlgorithm analysisAlgorithm) {
        SingleConsumer.analysisAlgorithm = analysisAlgorithm;
    }


    public static void consume() {

        while (true) {
            try {
                String analysisBatchId = Buffer.queue.take();
                log.info("SingleConsumer[消费者]|线程id:【" + Thread.currentThread().getId() + "】=============分析批次ID:【" + analysisBatchId + "】");

                analysisAlgorithm.analysis(analysisBatchId);

            } catch (Exception e) {
                StackTraceElement[] stackTrace = e.getStackTrace();
                String exceptionMessage = "错误类名:" +
                        stackTrace[0].getClassName() +
                        ".错误方法名:" +
                        stackTrace[0].getMethodName() +
                        ".错误行号:" +
                        stackTrace[0].getLineNumber() +
                        ".异常:" +
                        e.toString();
                log.error("SingleConsumer[消费者]|线程id:【" + Thread.currentThread().getId() + "】异常信息:" + exceptionMessage);
                e.printStackTrace();
            }

        }

    }

}
