package org.jeecg.modules.dynamicStaticAnalysis.controller;


import cn.hutool.core.util.ObjectUtil;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.jeecg.common.api.vo.Result;
import org.jeecg.common.aspect.annotation.AutoLog;
import org.jeecg.common.system.base.controller.JeecgController;
import org.jeecg.modules.dynamicStaticAnalysis.dto.AnalysisBatchUnitDeviceDTO;
import org.jeecg.modules.dynamicStaticAnalysis.entity.AnalysisBatchUnitDevice;
import org.jeecg.modules.dynamicStaticAnalysis.face.AnalysisBatchUnitDeviceFace;
import org.jeecg.modules.dynamicStaticAnalysis.service.IAnalysisBatchUnitDeviceService;
import org.jeecg.modules.dynamicStaticAnalysis.vo.AnalysisBatchUnitDeviceVO;
import org.jeecg.modules.unitDevice.vo.CaseReportCheckDataDetailVO;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;

/**
 * <p>
 * 动静态分析-分析批次-单元设备 前端控制器
 * </p>
 *
 * @author hkl
 * @since 2023-08-03
 */
@RestController
@RequestMapping("/dynamicStaticAnalysis/analysisBatchUnitDevice")
@Api(tags = "动静态分析-分析批次-单元设备")
public class AnalysisBatchUnitDeviceController extends JeecgController<AnalysisBatchUnitDevice, IAnalysisBatchUnitDeviceService> {


    @Resource
    private AnalysisBatchUnitDeviceFace analysisBatchUnitDeviceFace;

    @AutoLog(value = "动静态分析-分析批次-单元设备-获取列表数据")
    @ApiOperation(value = "动静态分析-分析批次-单元设备-获取列表数据", notes = "动静态分析-分析批次-单元设备-获取列表数据")
    @PostMapping(value = "/listRecord")
    public Result<IPage<AnalysisBatchUnitDeviceVO>> listRecord(@RequestBody AnalysisBatchUnitDeviceDTO dto) {
        Page<AnalysisBatchUnitDeviceVO> pageData = new Page<>(dto.getPageNo(), dto.getPageSize());
        if (ObjectUtil.isNotEmpty(dto.getUnitTypeList()) && ObjectUtil.isNotEmpty(dto.getGradeJudgeList())) {
            pageData = this.service.listRecord(pageData, dto);
        }


        return Result.OK(pageData);
    }


    @AutoLog(value = "动静态分析-分析批次-单元设备-检查数据")
    @ApiOperation(value = "动静态分析-分析批次-单元设备-检查数据", notes = "动静态分析-分析批次-单元设备-检查数据")
    @GetMapping(value = "/checkData")
    public Result<CaseReportCheckDataDetailVO> checkData(String id) {

        CaseReportCheckDataDetailVO vo = analysisBatchUnitDeviceFace.checkData(id);

        return Result.OK(vo);
    }


}
