package org.jeecg.modules.dynamicStaticAnalysis.controller;


import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.jeecg.common.api.vo.Result;
import org.jeecg.common.aspect.annotation.AutoLog;
import org.jeecg.common.system.base.controller.JeecgController;
import org.jeecg.common.util.UUIDGenerator;
import org.jeecg.modules.dynamicStaticAnalysis.entity.ConfigDispatching;
import org.jeecg.modules.dynamicStaticAnalysis.service.IConfigDispatchingService;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * <p>
 * 动静态分析-参数配置-派工配置 前端控制器
 * </p>
 *
 * @author hkl
 * @since 2023-08-03
 */
@RestController
@RequestMapping("/dynamicStaticAnalysis/dispatchingConfig")
@Api(tags = "动静态分析-参数配置-容许值差")
public class ConfigDispatchingController extends JeecgController<ConfigDispatching, IConfigDispatchingService> {


    @AutoLog(value = "动静态分析-参数配置-派工配置-查询所有参数")
    @ApiOperation(value = "动静态分析-参数配置-派工配置-查询所有参数", notes = "动静态分析-参数配置-派工配置-查询所有参数")
    @GetMapping(value = "/listRecord")
    public Result<List<ConfigDispatching>> listRecord() {
        return Result.OK(this.service.list());
    }


    @AutoLog(value = "动静态分析-参数配置-派工配置-新增")
    @ApiOperation(value = "动静态分析-参数配置-派工配置-新增", notes = "动静态分析-参数配置-派工配置-新增")
    @PostMapping(value = "/saveRecord")
    public Result<String> saveRecord(@RequestBody ConfigDispatching record) {
        record.setId(UUIDGenerator.generate());
        this.service.save(record);
        return Result.OK("操作成功");
    }


    @AutoLog(value = "动静态分析-参数配置-派工配置-批量更新")
    @ApiOperation(value = "动静态分析-参数配置-派工配置-批量更新", notes = "动静态分析-参数配置-派工配置-批量更新")
    @PostMapping(value = "/batchUpdateRecord")
    public Result<String> batchUpdateRecord(@RequestBody List<ConfigDispatching> records) {
        this.service.updateBatchById(records);
        return Result.OK("操作成功");
    }
}
