package org.jeecg.modules.dynamicStaticAnalysis.controller;


import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.jeecg.common.api.vo.Result;
import org.jeecg.common.aspect.annotation.AutoLog;
import org.jeecg.common.util.UUIDGenerator;
import org.jeecg.modules.dynamicStaticAnalysis.entity.ConfigDispatching;
import org.jeecg.modules.dynamicStaticAnalysis.entity.ConfigTqiLimit;
import org.jeecg.modules.dynamicStaticAnalysis.service.IConfigTqiLimitService;
import org.jeecg.modules.dynamicStaticAnalysis.vo.ConfigTqiLimitVO;
import org.springframework.web.bind.annotation.*;

import org.jeecg.common.system.base.controller.JeecgController;

import java.util.List;

/**
 * <p>
 * 动静态分析-配置参数-TQI管理标准顺质量指数 前端控制器
 * </p>
 *
 * @author hkl
 * @since 2023-09-15
 */
@RestController
@RequestMapping("/dynamicStaticAnalysis/configTqiLimit")
@Api(tags = "动静态分析-配置参数-TQI管理标准顺质量指数")
public class ConfigTqiLimitController extends JeecgController<ConfigTqiLimit, IConfigTqiLimitService> {

    @AutoLog(value = "动静态分析-配置参数-TQI管理标准顺质量指数-查询所有参数")
    @ApiOperation(value = "动静态分析-配置参数-TQI管理标准顺质量指数-查询所有参数", notes = "动静态分析-配置参数-TQI管理标准顺质量指数-查询所有参数")
    @GetMapping(value = "/listRecord")
    public Result<List<ConfigTqiLimit>> listRecord() {

        List<ConfigTqiLimit> list = this.service.list();

        return Result.OK(list);
    }


    @AutoLog(value = "动静态分析-配置参数-TQI管理标准顺质量指数-批量更新")
    @ApiOperation(value = "动静态分析-配置参数-TQI管理标准顺质量指数-批量更新", notes = "动静态分析-配置参数-TQI管理标准顺质量指数-批量更新")
    @PostMapping(value = "/batchUpdateRecord")
    public Result<String> batchUpdateRecord(@RequestBody List<ConfigTqiLimit> records) {
        this.service.updateBatchById(records);
        return Result.OK("操作成功");
    }


}
