package org.jeecg.modules.dynamicStaticAnalysis.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

/**
 * <p>
 * 动静态分析-分析批次表
 * </p>
 *
 * @author hkl
 * @since 2023-07-26
 */
@Getter
@Setter
@TableName("t_dsa_analysis_batch")
@ApiModel(value = "AnalysisBatch对象", description = "动静态分析-分析批次表")
public class AnalysisBatch implements Serializable {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty("主键")
    @TableId("id")
    private String id;

    @ApiModelProperty("创建人")
    @TableField("create_by")
    private String createBy;

    @ApiModelProperty("创建日期")
    @TableField("create_time")
    private Date createTime;

    @ApiModelProperty("更新人")
    @TableField("update_by")
    private String updateBy;

    @ApiModelProperty("更新时间")
    @TableField("update_time")
    private Date updateTime;

    @ApiModelProperty("分析批次号")
    @TableField("analysis_batch_code")
    private String analysisBatchCode;

    @ApiModelProperty("所属线路id")
    @TableField("light_rail_id")
    private String lightRailId;

    @ApiModelProperty("所属线路名称")
    @TableField("light_rail_name")
    private String lightRailName;

    @ApiModelProperty("所属线别id")
    @TableField("line_alias_id")
    private String lineAliasId;

    @ApiModelProperty("所属线别名称")
    @TableField("line_alias_name")
    private String lineAliasName;

    @ApiModelProperty("起始里程")
    @TableField("starting_mileage")
    private BigDecimal startingMileage;

    @ApiModelProperty("终点里程")
    @TableField("end_mileage")
    private BigDecimal endMileage;

    @ApiModelProperty("分析类型 1-均值分析 2-峰值分析")
    @TableField("analysis_type")
    private Integer analysisType;

    @ApiModelProperty("评价速度等级字典值")
    @TableField("dict_value")
    private String dictValue;

    @ApiModelProperty("评价速度等级字典名称")
    @TableField("dict_label")
    private String dictLabel;

    @ApiModelProperty("速度下限")
    @TableField("speed_min")
    private Integer speedMin;

    @ApiModelProperty("速度上限")
    @TableField("speed_max")
    private Integer speedMax;

    @ApiModelProperty("容许值差")
    @TableField("allow_value")
    private String allowValue;

    @ApiModelProperty("派工设置")
    @TableField("dispatching")
    private String dispatching;

    @ApiModelProperty("分析状态 0-创建 1-分析中  99-分析完成")
    @TableField("analysis_status")
    private Integer analysisStatus;

    @ApiModelProperty("备注")
    @TableField("remark")
    private String remark;


}
