package org.jeecg.modules.dynamicStaticAnalysis.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

/**
 * <p>
 * 动静态分析-分析批次-单元设备超限
 * </p>
 *
 * @author hkl
 * @since 2023-08-04
 */
@Getter
@Setter
@TableName("t_dsa_analysis_batch_unit_device_transfinite")
@ApiModel(value = "AnalysisBatchUnitDeviceTransfinite对象", description = "动静态分析-分析批次-单元设备超限")
public class AnalysisBatchUnitDeviceTransfinite implements Serializable {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty("主键")
    @TableId("id")
    private String id;

    @ApiModelProperty("创建人")
    @TableField("create_by")
    private String createBy;

    @ApiModelProperty("创建日期")
    @TableField("create_time")
    private Date createTime;

    @ApiModelProperty("更新人")
    @TableField("update_by")
    private String updateBy;

    @ApiModelProperty("更新时间")
    @TableField("update_time")
    private Date updateTime;

    @ApiModelProperty("分析批次单元设备id")
    @TableField("analysis_batch_unit_device_id")
    private String analysisBatchUnitDeviceId;

    @ApiModelProperty("分析批次号")
    @TableField("analysis_batch_code")
    private String analysisBatchCode;

    @ApiModelProperty("分析批id")
    @TableField("analysis_batch_id")
    private String analysisBatchId;

    @ApiModelProperty("单元设备id")
    @TableField("unit_id")
    private String unitId;

    @ApiModelProperty("单元设备code")
    @TableField("unit_code")
    private String unitCode;

    @ApiModelProperty("设备单元类型1-钢轨,2-曲线,3-竖曲线,4-道岔")
    @TableField("unit_type")
    private Integer unitType;

    @ApiModelProperty("设备单元类型名称")
    @TableField("unit_type_name")
    private String unitTypeName;

    @ApiModelProperty("超限等级")
    @TableField("transfinite_grade")
    private Integer transfiniteGrade;

    @ApiModelProperty("超限等级名称")
    @TableField("transfinite_grade_name")
    private String transfiniteGradeName;

    @ApiModelProperty("超限类型")
    @TableField("transfinite_type")
    private String transfiniteType;

    @ApiModelProperty("容许值")
    @TableField("allow_value")
    private String allowValue;

    @ApiModelProperty("检查id")
    @TableField("ek_id")
    private String ekId;

    @ApiModelProperty("检查类型 检查数据类型 1-人工静态检查 2-轨检仪静态检查 3-轨检车检查 4-添乘仪检查")
    @TableField("ek_type")
    private Integer ekType;

    @ApiModelProperty("检查项目id(如果是人工和轨检查仪器就是检查项目id)")
    @TableField("ek_item_id")
    private String ekItemId;

    @ApiModelProperty("测点值")
    @TableField("measure_point_value")
    private String measurePointValue;

    @ApiModelProperty("是否派工 0-否 1-是")
    @TableField("is_work")
    private Integer isWork;

    @ApiModelProperty("病害里程")
    @TableField("disease_mileage")
    private BigDecimal diseaseMileage;

    @ApiModelProperty("备注")
    @TableField("remark")
    private String remark;


}
