package org.jeecg.modules.dynamicStaticAnalysis.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

/**
 * <p>
 * 动静态分析-配置-TQI管理标准顺质量指数
 * </p>
 *
 * @author hkl
 * @since 2023-09-15
 */
@Getter
@Setter
@TableName("t_dsa_config_tqi_limit")
@ApiModel(value = "ConfigTqiLimit对象", description = "动静态分析-配置-TQI管理标准顺质量指数")
public class ConfigTqiLimit implements Serializable {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty("主键")
    @TableId("id")
    private String id;

    @ApiModelProperty("创建人")
    @TableField("create_by")
    private String createBy;

    @ApiModelProperty("创建日期")
    @TableField("create_time")
    private Date createTime;

    @ApiModelProperty("更新人")
    @TableField("update_by")
    private String updateBy;

    @ApiModelProperty("更新时间")
    @TableField("update_time")
    private Date updateTime;

    @ApiModelProperty("速度下限")
    @TableField("speed_min")
    private Integer speedMin;

    @ApiModelProperty("速度上限")
    @TableField("speed_max")
    private Integer speedMax;

    @ApiModelProperty("数据字典标签")
    @TableField("dict_label")
    private String dictLabel;

    @ApiModelProperty("数据字典值")
    @TableField("dict_value")
    private String dictValue;

    @ApiModelProperty("超标类型 1-超标≤10% 2-超标≤20% 3-超标>20%")
    @TableField("over_standard_type")
    private Integer overStandardType;

    @ApiModelProperty("评价等级中文说明")
    @TableField("over_standard_type_str")
    private String overStandardTypeStr;

    @ApiModelProperty("tqi下限")
    @TableField("tqi_min")
    private BigDecimal tqiMin;

    @ApiModelProperty("tqi上限")
    @TableField("tqi_max")
    private BigDecimal tqiMax;

    @ApiModelProperty("是否删除（0：未删除； 1：已删除）")
    @TableField("del_flag")
    private String delFlag;

    @ApiModelProperty("备注")
    @TableField("remark")
    private String remark;


}
