package org.jeecg.modules.dynamicStaticAnalysis.mapper;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.jeecg.modules.dynamicStaticAnalysis.dto.AnalysisBatchQueryDTO;
import org.jeecg.modules.dynamicStaticAnalysis.dto.CheckBatchDTO;
import org.jeecg.modules.dynamicStaticAnalysis.entity.AnalysisBatch;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import org.jeecg.modules.dynamicStaticAnalysis.vo.AnalysisBatchQueryVO;
import org.jeecg.modules.dynamicStaticAnalysis.vo.CheckBatchVO;
import org.jeecg.modules.homePage.dto.DiseaseDTO;
import org.jeecg.modules.homePage.vo.DiseaseVO;
import org.jeecg.modules.homePage.vo.ToDoDetailVO;

import java.util.List;
import java.util.Map;

/**
 * <p>
 * 动静态分析-分析批次表 Mapper 接口
 * </p>
 *
 * @author hkl
 * @since 2023-07-26
 */
public interface AnalysisBatchMapper extends BaseMapper<AnalysisBatch> {

    Page<CheckBatchVO> getCheckData(Page<CheckBatchVO> pageData, CheckBatchDTO dto);

    Page<AnalysisBatchQueryVO> listRecord(Page<AnalysisBatchQueryVO> pageData, AnalysisBatchQueryDTO dto);

    List<CheckBatchVO> listRecordDetail(List<String> analysisBatchIds);

    List<ToDoDetailVO> getTodoList(String currentUserId);

    List<Map<String, Object>> getIsEditList(List<String> analysisBatchIds);

    List<DiseaseVO> diseaseList(String analysisBatchCode);
}
